/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal38SparseWriter;

public class Decimal38SparseHolderReaderImpl
extends AbstractFieldReader {
    private Decimal38SparseHolder holder;

    public Decimal38SparseHolderReaderImpl(Decimal38SparseHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(Decimal38SparseHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
    }

    @Override
    public void read(NullableDecimal38SparseHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        return DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 6, this.holder.scale);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        return DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 6, this.holder.scale);
    }

    @Override
    public void copyAsValue(Decimal38SparseWriter writer) {
        writer.write(this.holder);
    }
}

