/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.DateWriter;

public class DateHolderReaderImpl
extends AbstractFieldReader {
    private DateHolder holder;

    public DateHolderReaderImpl(DateHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return DateHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(DateHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableDateHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDate readLocalDate() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void copyAsValue(DateWriter writer) {
        writer.write(this.holder);
    }
}

