/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.Decimal18Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal18Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.Decimal18Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDecimal18ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal18Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Decimal18Vector values;
    private final FieldReader reader = new RepeatedDecimal18ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal18Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withScaleAndPrecision(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getScale(), majorType.getPrecision())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Decimal18Vector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedDecimal18Vector)to);
    }

    public AddOrGetResult<Decimal18Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<Decimal18Vector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedDecimal18Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedDecimal18Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedDecimal18Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedDecimal18Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedDecimal18Vector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, long value) {
            int nextOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal18Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedDecimal18Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, long srcValue) {
            int nextOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal18Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedDecimal18Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedDecimal18Holder h) {
            Decimal18Holder ih = new Decimal18Holder();
            Decimal18Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedDecimal18Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedDecimal18Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Decimal18Holder holder) {
            int nextOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal18Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal18Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableDecimal18Holder holder) {
            int nextOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal18Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal18Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedDecimal18Vector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, Decimal18Holder holder) {
            int nextOffset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal18Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedDecimal18Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedDecimal18Holder holder) {
            Decimal18Vector.Accessor accessor = holder.vector.getAccessor();
            Decimal18Holder innerHolder = new Decimal18Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedDecimal18Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedDecimal18Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedDecimal18Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Decimal18Vector.Accessor valuesAccessor = RepeatedDecimal18Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public BigDecimal getSingleObject(int index, int arrayIndex) {
            int start = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index);
            return RepeatedDecimal18Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public long get(int index, int positionIndex) {
            return RepeatedDecimal18Vector.this.values.getAccessor().get(RepeatedDecimal18Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedDecimal18Holder holder) {
            holder.start = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedDecimal18Vector.this.values;
            RepeatedDecimal18Vector.this.reader.setPosition(index);
            holder.reader = RepeatedDecimal18Vector.this.reader;
        }

        public void get(int index, int positionIndex, Decimal18Holder holder) {
            int offset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedDecimal18Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableDecimal18Holder holder) {
            int offset = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedDecimal18Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedDecimal18Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedDecimal18Vector(field, allocator);
        }

        public TransferImpl(RepeatedDecimal18Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedDecimal18Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedDecimal18Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedDecimal18Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedDecimal18Vector.this);
        }
    }
}

