/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMemoryRetention {
    private static final Logger logger = LoggerFactory.getLogger(TestMemoryRetention.class);
    private static final int SMALL_AVERAGE_BYTES = 32768;
    private static final int LARGE_BYTES = 0x2000000;
    private static final int PARALLEL_THREADS = 32;
    private static final double SMALL_ALLOCATION_MEM = 0.2;
    private static final double OVERHEAD_ALLOWANCE = 0.2;
    private static final List<Integer> ALLOCATIONS;
    private static final int MAX_ALLOCS = 100;
    private static final AtomicInteger ALLOCS;

    public static void main(String[] args) throws Exception {
        DrillConfig config = DrillConfig.create();
        BufferAllocator a = RootAllocatorFactory.newRoot(config);
        for (int i = 0; i < 32; ++i) {
            Alloc alloc = new Alloc(a);
            alloc.start();
        }
    }

    static {
        ALLOCS = new AtomicInteger(0);
        Random r = new Random();
        long maxMemory = DrillConfig.getMaxDirectMemory();
        long maxPerThread = maxMemory / 32L;
        double smallCount = (double)maxPerThread * 0.2 / 32768.0;
        double largeCount = (double)maxPerThread * 0.6000000000000001 / 3.3554432E7;
        ArrayList<Integer> allocations = Lists.newArrayList();
        int i = 0;
        while ((double)i < smallCount) {
            allocations.add(16384 + r.nextInt(32768));
            ++i;
        }
        i = 0;
        while ((double)i < largeCount) {
            allocations.add(0x2000000);
            ++i;
        }
        Collections.shuffle(allocations);
        ALLOCATIONS = allocations;
    }

    private static class Dealloc
    extends Thread {
        final List<DrillBuf> bufs;
        final BufferAllocator a;

        public Dealloc(List<DrillBuf> bufs, BufferAllocator a) {
            this.bufs = bufs;
            this.a = a;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(8000L);
                logger.info("Starting release.");
                for (DrillBuf buf : this.bufs) {
                    buf.release();
                }
                logger.info("Finished release.");
            }
            catch (InterruptedException e) {
                return;
            }
            Alloc alloc = new Alloc(this.a);
            alloc.start();
        }
    }

    private static class Alloc
    extends Thread {
        final BufferAllocator allocator;

        Alloc(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public void run() {
            Random r = new Random();
            try {
                if (ALLOCS.incrementAndGet() > 100) {
                    Thread.sleep(50000000000L);
                }
                Thread.sleep(r.nextInt(8000));
            }
            catch (InterruptedException e) {
                return;
            }
            logger.info("Starting alloc.");
            LinkedList<DrillBuf> bufs = Lists.newLinkedList();
            for (Integer i : ALLOCATIONS) {
                bufs.add(this.allocator.buffer(i));
            }
            Collections.shuffle(bufs);
            logger.info("Finished alloc.");
            Dealloc d = new Dealloc(bufs, this.allocator);
            if (r.nextBoolean()) {
                d.start();
            } else {
                d.run();
            }
        }
    }
}

