/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.configuration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.commons.configuration.AbstractConfiguration;
import oadd.org.apache.commons.configuration.Configuration;
import oadd.org.apache.commons.configuration.ConfigurationRuntimeException;
import oadd.org.apache.commons.configuration.ConfigurationUtils;
import oadd.org.apache.commons.configuration.HierarchicalReloadableConfiguration;
import oadd.org.apache.commons.configuration.Lock;
import oadd.org.apache.commons.configuration.event.ConfigurationEvent;
import oadd.org.apache.commons.configuration.event.ConfigurationListener;
import oadd.org.apache.commons.configuration.tree.ConfigurationNode;
import oadd.org.apache.commons.configuration.tree.DefaultConfigurationKey;
import oadd.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import oadd.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import oadd.org.apache.commons.configuration.tree.ExpressionEngine;
import oadd.org.apache.commons.configuration.tree.NodeCombiner;
import oadd.org.apache.commons.configuration.tree.TreeUtils;
import oadd.org.apache.commons.configuration.tree.UnionCombiner;
import oadd.org.apache.commons.configuration.tree.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedConfiguration
extends HierarchicalReloadableConfiguration
implements ConfigurationListener,
Cloneable {
    public static final int EVENT_COMBINED_INVALIDATE = 40;
    private static final long serialVersionUID = 8338574525528692307L;
    private static final DefaultExpressionEngine AT_ENGINE = new DefaultExpressionEngine();
    private static final NodeCombiner DEFAULT_COMBINER = new UnionCombiner();
    private static final String PROP_RELOAD_CHECK = "CombinedConfigurationReloadCheck";
    private NodeCombiner nodeCombiner;
    private volatile ConfigurationNode combinedRoot;
    private List<ConfigData> configurations;
    private Map<String, AbstractConfiguration> namedConfigurations;
    private boolean ignoreReloadExceptions = true;
    private boolean reloadRequired;
    private ExpressionEngine conversionExpressionEngine;
    private boolean forceReloadCheck;

    public CombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(NodeCombiner comb, Lock lock) {
        super(lock);
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(Lock lock) {
        this(null, lock);
    }

    public CombinedConfiguration() {
        this(null, null);
    }

    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidate();
    }

    public boolean isForceReloadCheck() {
        return this.forceReloadCheck;
    }

    public void setForceReloadCheck(boolean forceReloadCheck) {
        this.forceReloadCheck = forceReloadCheck;
    }

    public ExpressionEngine getConversionExpressionEngine() {
        return this.conversionExpressionEngine;
    }

    public void setConversionExpressionEngine(ExpressionEngine conversionExpressionEngine) {
        this.conversionExpressionEngine = conversionExpressionEngine;
    }

    public boolean isIgnoreReloadExceptions() {
        return this.ignoreReloadExceptions;
    }

    public void setIgnoreReloadExceptions(boolean ignoreReloadExceptions) {
        this.ignoreReloadExceptions = ignoreReloadExceptions;
    }

    public void addConfiguration(AbstractConfiguration config, String name, String at) {
        if (config == null) {
            throw new IllegalArgumentException("Added configuration must not be null!");
        }
        if (name != null && this.namedConfigurations.containsKey(name)) {
            throw new ConfigurationRuntimeException("A configuration with the name '" + name + "' already exists in this combined configuration!");
        }
        ConfigData cd = new ConfigData(config, name, at);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Adding configuration " + config + " with name " + name));
        }
        this.configurations.add(cd);
        if (name != null) {
            this.namedConfigurations.put(name, config);
        }
        config.addConfigurationListener(this);
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        this.addConfiguration(config, name, null);
    }

    public void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, null, null);
    }

    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    public Configuration getConfiguration(int index) {
        ConfigData cd = this.configurations.get(index);
        return cd.getConfiguration();
    }

    public Configuration getConfiguration(String name) {
        return this.namedConfigurations.get(name);
    }

    public List<AbstractConfiguration> getConfigurations() {
        ArrayList<AbstractConfiguration> list = new ArrayList<AbstractConfiguration>(this.configurations.size());
        for (ConfigData cd : this.configurations) {
            list.add(cd.getConfiguration());
        }
        return list;
    }

    public List<String> getConfigurationNameList() {
        ArrayList<String> list = new ArrayList<String>(this.configurations.size());
        for (ConfigData cd : this.configurations) {
            list.add(cd.getName());
        }
        return list;
    }

    public boolean removeConfiguration(Configuration config) {
        for (int index = 0; index < this.getNumberOfConfigurations(); ++index) {
            if (this.configurations.get(index).getConfiguration() != config) continue;
            this.removeConfigurationAt(index);
            return true;
        }
        return false;
    }

    public Configuration removeConfigurationAt(int index) {
        ConfigData cd = this.configurations.remove(index);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        cd.getConfiguration().removeConfigurationListener(this);
        this.invalidate();
        return cd.getConfiguration();
    }

    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    public void invalidate() {
        this.reloadRequired = true;
        this.fireEvent(40, null, null, false);
    }

    @Override
    public void configurationChanged(ConfigurationEvent event) {
        if (event.getType() == 21) {
            this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
        } else if (!event.isBeforeUpdate()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationNode getRootNode() {
        Object object = this.getReloadLock();
        synchronized (object) {
            if (this.reloadRequired || this.combinedRoot == null) {
                this.combinedRoot = this.constructCombinedNode();
                this.reloadRequired = false;
            }
            return this.combinedRoot;
        }
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.configurations = new ArrayList<ConfigData>();
        this.namedConfigurations = new HashMap<String, AbstractConfiguration>();
        this.fireEvent(4, null, null, false);
        this.invalidate();
    }

    @Override
    public Object clone() {
        CombinedConfiguration copy = (CombinedConfiguration)super.clone();
        copy.clear();
        for (ConfigData cd : this.configurations) {
            copy.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration(cd.getConfiguration()), cd.getName(), cd.getAt());
        }
        copy.setRootNode(new DefaultConfigurationNode());
        return copy;
    }

    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        if (nodes.isEmpty()) {
            return null;
        }
        Iterator<ConfigurationNode> it = nodes.iterator();
        Configuration source = this.findSourceConfiguration(it.next());
        while (it.hasNext()) {
            Configuration src = this.findSourceConfiguration(it.next());
            if (src == source) continue;
            throw new IllegalArgumentException("The key " + key + " is defined by multiple sources!");
        }
        return source;
    }

    @Override
    protected List<ConfigurationNode> fetchNodeList(String key) {
        if (this.isForceReloadCheck()) {
            this.performReloadCheck();
        }
        return super.fetchNodeList(key);
    }

    protected void performReloadCheck() {
        for (ConfigData cd : this.configurations) {
            try {
                cd.getConfiguration().getProperty(PROP_RELOAD_CHECK);
            }
            catch (Exception ex) {
                if (this.ignoreReloadExceptions) continue;
                throw new ConfigurationRuntimeException(ex);
            }
        }
    }

    private ConfigurationNode constructCombinedNode() {
        if (this.getNumberOfConfigurations() < 1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("No configurations defined for " + this));
            }
            return new ViewNode();
        }
        Iterator<ConfigData> it = this.configurations.iterator();
        ConfigurationNode node = it.next().getTransformedRoot();
        while (it.hasNext()) {
            node = this.getNodeCombiner().combine(node, it.next().getTransformedRoot());
        }
        if (this.getLogger().isDebugEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(os);
            TreeUtils.printTree(stream, node);
            this.getLogger().debug((Object)os.toString());
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration findSourceConfiguration(ConfigurationNode node) {
        Object object = this.getReloadLock();
        synchronized (object) {
            ConfigurationNode root = null;
            for (ConfigurationNode current = node; current != null; current = current.getParentNode()) {
                root = current;
            }
            for (ConfigData cd : this.configurations) {
                if (root != cd.getRootNode()) continue;
                return cd.getConfiguration();
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private Collection<String> atPath;
        private String at;
        private ConfigurationNode rootNode;

        public ConfigData(AbstractConfiguration config, String n, String at) {
            this.configuration = config;
            this.name = n;
            this.atPath = this.parseAt(at);
            this.at = at;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }

        public ConfigurationNode getRootNode() {
            return this.rootNode;
        }

        public ConfigurationNode getTransformedRoot() {
            ViewNode result;
            ViewNode atParent = result = new ViewNode();
            if (this.atPath != null) {
                for (String p : this.atPath) {
                    ViewNode node = new ViewNode();
                    node.setName(p);
                    atParent.addChild(node);
                    atParent = node;
                }
            }
            ConfigurationNode root = ConfigurationUtils.convertToHierarchical(this.getConfiguration(), CombinedConfiguration.this.getConversionExpressionEngine()).getRootNode();
            atParent.appendChildren(root);
            atParent.appendAttributes(root);
            this.rootNode = root;
            return result;
        }

        private Collection<String> parseAt(String at) {
            if (at == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            DefaultConfigurationKey.KeyIterator it = new DefaultConfigurationKey(AT_ENGINE, at).iterator();
            while (it.hasNext()) {
                result.add(it.nextKey());
            }
            return result;
        }
    }
}

