/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import oadd.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class StringFieldPropertyWriter
extends OptimizedBeanPropertyWriter<StringFieldPropertyWriter> {
    private static final long serialVersionUID = 1L;

    public StringFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringFieldPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringField(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, false);
            return;
        }
        if (value == null) {
            if (this._nullSerializer != null) {
                gen.writeFieldName(this._fastName);
                this._nullSerializer.serialize(null, gen, prov);
            } else if (!this._suppressNulls) {
                gen.writeFieldName(this._fastName);
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
            return;
        }
        gen.writeFieldName(this._fastName);
        gen.writeString(value);
    }

    @Override
    public final void serializeAsElement(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.stringField(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, true);
            return;
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (value.length() == 0) {
                    this.serializeAsPlaceholder(bean2, gen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean2, gen, prov);
                return;
            }
        }
        gen.writeString(value);
    }
}

