/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import oadd.com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import oadd.com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableStringFieldProperty
extends OptimizedSettableBeanProperty<SettableStringFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableStringFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableStringFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            this.delegate.deserializeAndSet(p, ctxt, bean2);
            return;
        }
        String text = p.getText();
        try {
            this._propertyMutator.stringField(bean2, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, text, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this.setAndReturn(instance, p.getText());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(Object bean2, Object value) throws IOException {
        String text = (String)value;
        try {
            this._propertyMutator.stringField(bean2, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, text, e);
        }
    }
}

