/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import oadd.com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import oadd.com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableBooleanMethodProperty
extends OptimizedSettableBeanProperty<SettableBooleanMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableBooleanMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableBooleanMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        boolean b;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            b = true;
        } else if (t == JsonToken.VALUE_FALSE) {
            b = false;
        } else {
            this.delegate.deserializeAndSet(p, ctxt, bean2);
            return;
        }
        try {
            this._propertyMutator.booleanSetter(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, b, e);
        }
    }

    @Override
    public void set(Object bean2, Object value) throws IOException {
        boolean b = (Boolean)value;
        try {
            this._propertyMutator.booleanSetter(bean2, this._optimizedIndex, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean2, b, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return this.setAndReturn(instance, Boolean.TRUE);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return this.setAndReturn(instance, Boolean.FALSE);
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }
}

