/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder.utils;

public class UtilFunctions {
    public static boolean compare32Bytes(byte[] data, byte[] comparedArray, boolean isBigEndian) {
        if (data.length == 4 && comparedArray.length == 4) {
            boolean error = false;
            if (isBigEndian) {
                for (int i = 0; i < 4; ++i) {
                    if (data[i] == comparedArray[i]) continue;
                    error = true;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (data[3 - i] == comparedArray[i]) continue;
                    error = true;
                }
            }
            if (!error) {
                return true;
            }
        }
        return false;
    }

    public static String byteArrayToStringMessage(String message, byte[] array, char separator) {
        String log = "";
        if (!"".equals(message)) {
            log = message + " : ";
        }
        if (array != null) {
            for (int count = 0; count < array.length; ++count) {
                log = count == 0 ? log + UtilFunctions.convertFromIntToHexa(array[count]) + " " + separator + " " : (count != array.length - 1 ? log + UtilFunctions.convertFromIntToHexa(array[count]) + " " + separator + " " : log + UtilFunctions.convertFromIntToHexa(array[count]));
            }
        }
        return log;
    }

    public static String convertFromIntToHexa(byte data) {
        int dataTmp = data & 0xFF;
        String value = Integer.toHexString(dataTmp).toUpperCase();
        if (value.length() == 1) {
            value = "0" + value;
        }
        return value;
    }

    public static int convertByteArrayToInt(byte[] array) {
        int ret = 0;
        for (int i = 0; i < array.length; ++i) {
            ret += (array[i] & 0xFF) << (array.length - 1 - i) * 8;
        }
        return ret;
    }

    public static Long convertByteArrayToLong(byte[] array) {
        Long ret = 0L;
        for (int i = 0; i < array.length; ++i) {
            ret = ret + ((long)(array[i] & 0xFF) << (array.length - 1 - i) * 8);
        }
        return ret;
    }

    public static byte[] convertLeToBe(byte[] data) {
        byte[] temp = new byte[data.length];
        for (int i = data.length - 1; i >= 0; --i) {
            temp[data.length - 1 - i] = data[i];
        }
        return temp;
    }
}

