/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.cdi;

import com.sun.jersey.server.impl.cdi.CDIExtension;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static Bean<?> getBean(BeanManager beanManager, Class<?> clazz) {
        Set beans2 = beanManager.getBeans(clazz, new Annotation[0]);
        if (beans2.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("No CDI beans found in bean manager, %s, for type %s", beanManager, clazz));
            }
            return null;
        }
        try {
            return beanManager.resolve(beans2);
        }
        catch (AmbiguousResolutionException ex) {
            if (Utils.isSharedBaseClass(clazz, beans2)) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Ambiguous resolution exception caught when resolving bean %s. Trying to resolve by the type %s", beans2, clazz));
                    }
                    return beanManager.resolve(Utils.getBaseClassSubSet(clazz, beans2));
                }
                catch (AmbiguousResolutionException ex2) {
                    return null;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Failed to resolve bean %s.", beans2));
            }
            return null;
        }
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> c) {
        Bean<?> bean2 = Utils.getBean(beanManager, c);
        if (bean2 == null) {
            return null;
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(bean2);
        Object result = beanManager.getReference(bean2, c, creationalContext);
        return c.cast(result);
    }

    public static CDIExtension getCdiExtensionInstance(BeanManager beanManager) {
        Set beans2 = beanManager.getBeans(CDIExtension.class, new Annotation[0]);
        if (beans2.isEmpty()) {
            return null;
        }
        try {
            return Utils.getCdiExtensionReference(beanManager.resolve(beans2), beanManager);
        }
        catch (AmbiguousResolutionException ex) {
            for (Bean b : beans2) {
                CDIExtension cdiExtension = Utils.getCdiExtensionReference(b, beanManager);
                if (cdiExtension.toBeInitializedLater == null) continue;
                return cdiExtension;
            }
            return null;
        }
    }

    private static CDIExtension getCdiExtensionReference(Bean extensionBean, BeanManager beanManager) {
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)extensionBean);
        Object result = beanManager.getReference(extensionBean, CDIExtension.class, creationalContext);
        return (CDIExtension)result;
    }

    private static boolean isSharedBaseClass(Class<?> clazz, Set<Bean<?>> beans2) {
        for (Bean<?> bean2 : beans2) {
            if (clazz.isAssignableFrom(bean2.getBeanClass())) continue;
            return false;
        }
        return true;
    }

    private static Set<Bean<?>> getBaseClassSubSet(Class<?> clazz, Set<Bean<?>> beans2) {
        for (Bean<?> bean2 : beans2) {
            if (clazz != bean2.getBeanClass()) continue;
            return Collections.singleton(bean2);
        }
        return beans2;
    }
}

