/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.store;

import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.EventBasedRecordWriter.FieldConverter;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.BitVector.Accessor;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

import java.io.IOException;
import java.lang.UnsupportedOperationException;

/*
 * This class is generated using freemarker and the AbstractRecordWriter.java template.
 */
public abstract class AbstractRecordWriter implements RecordWriter {

  private Accessor newPartitionVector;

  protected void setPartitionVector(BitVector newPartitionVector) {
    this.newPartitionVector = newPartitionVector.getAccessor();
  }

  protected boolean newPartition(int index) {
    return newPartitionVector.get(index) == 1;
  }

  public void checkForNewPartition(int index) {
    // no op
  }

  @Override
  public FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing Map'");
  }

  @Override
  public FieldConverter getNewUnionConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing Union type'");
  }

  @Override
  public FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing RepeatedMap");
  }

  @Override
  public FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing RepeatedList");
  }

  @Override
  public FieldConverter getNewDictConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing Dict");
  }

  @Override
  public FieldConverter getNewRepeatedDictConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing RepeatedDict");
  }

  @Override
  public FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableTinyInt'");
  }
  @Override
  public FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'TinyInt'");
  }
  @Override
  public FieldConverter getNewRepeatedTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedTinyInt'");
  }
  @Override
  public FieldConverter getNewNullableUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableUInt1'");
  }
  @Override
  public FieldConverter getNewUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'UInt1'");
  }
  @Override
  public FieldConverter getNewRepeatedUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedUInt1'");
  }
  @Override
  public FieldConverter getNewNullableUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableUInt2'");
  }
  @Override
  public FieldConverter getNewUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'UInt2'");
  }
  @Override
  public FieldConverter getNewRepeatedUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedUInt2'");
  }
  @Override
  public FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableSmallInt'");
  }
  @Override
  public FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'SmallInt'");
  }
  @Override
  public FieldConverter getNewRepeatedSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedSmallInt'");
  }
  @Override
  public FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableInt'");
  }
  @Override
  public FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Int'");
  }
  @Override
  public FieldConverter getNewRepeatedIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedInt'");
  }
  @Override
  public FieldConverter getNewNullableUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableUInt4'");
  }
  @Override
  public FieldConverter getNewUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'UInt4'");
  }
  @Override
  public FieldConverter getNewRepeatedUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedUInt4'");
  }
  @Override
  public FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableFloat4'");
  }
  @Override
  public FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Float4'");
  }
  @Override
  public FieldConverter getNewRepeatedFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedFloat4'");
  }
  @Override
  public FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableTime'");
  }
  @Override
  public FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Time'");
  }
  @Override
  public FieldConverter getNewRepeatedTimeConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedTime'");
  }
  @Override
  public FieldConverter getNewNullableIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableIntervalYear'");
  }
  @Override
  public FieldConverter getNewIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'IntervalYear'");
  }
  @Override
  public FieldConverter getNewRepeatedIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedIntervalYear'");
  }
  @Override
  public FieldConverter getNewNullableDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal9'");
  }
  @Override
  public FieldConverter getNewDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal9'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal9'");
  }
  @Override
  public FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableBigInt'");
  }
  @Override
  public FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'BigInt'");
  }
  @Override
  public FieldConverter getNewRepeatedBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedBigInt'");
  }
  @Override
  public FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableUInt8'");
  }
  @Override
  public FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'UInt8'");
  }
  @Override
  public FieldConverter getNewRepeatedUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedUInt8'");
  }
  @Override
  public FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableFloat8'");
  }
  @Override
  public FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Float8'");
  }
  @Override
  public FieldConverter getNewRepeatedFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedFloat8'");
  }
  @Override
  public FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDate'");
  }
  @Override
  public FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Date'");
  }
  @Override
  public FieldConverter getNewRepeatedDateConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDate'");
  }
  @Override
  public FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableTimeStamp'");
  }
  @Override
  public FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'TimeStamp'");
  }
  @Override
  public FieldConverter getNewRepeatedTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedTimeStamp'");
  }
  @Override
  public FieldConverter getNewNullableDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal18'");
  }
  @Override
  public FieldConverter getNewDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal18'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal18'");
  }
  @Override
  public FieldConverter getNewNullableIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableIntervalDay'");
  }
  @Override
  public FieldConverter getNewIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'IntervalDay'");
  }
  @Override
  public FieldConverter getNewRepeatedIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedIntervalDay'");
  }
  @Override
  public FieldConverter getNewNullableIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableInterval'");
  }
  @Override
  public FieldConverter getNewIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Interval'");
  }
  @Override
  public FieldConverter getNewRepeatedIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedInterval'");
  }
  @Override
  public FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal28Dense'");
  }
  @Override
  public FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal28Dense'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal28Dense'");
  }
  @Override
  public FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal38Dense'");
  }
  @Override
  public FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal38Dense'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal38Dense'");
  }
  @Override
  public FieldConverter getNewNullableDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal38Sparse'");
  }
  @Override
  public FieldConverter getNewDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal38Sparse'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal38Sparse'");
  }
  @Override
  public FieldConverter getNewNullableDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableDecimal28Sparse'");
  }
  @Override
  public FieldConverter getNewDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Decimal28Sparse'");
  }
  @Override
  public FieldConverter getNewRepeatedDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedDecimal28Sparse'");
  }
  @Override
  public FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableVarBinary'");
  }
  @Override
  public FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'VarBinary'");
  }
  @Override
  public FieldConverter getNewRepeatedVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedVarBinary'");
  }
  @Override
  public FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableVarChar'");
  }
  @Override
  public FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'VarChar'");
  }
  @Override
  public FieldConverter getNewRepeatedVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedVarChar'");
  }
  @Override
  public FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableVar16Char'");
  }
  @Override
  public FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Var16Char'");
  }
  @Override
  public FieldConverter getNewRepeatedVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedVar16Char'");
  }
  @Override
  public FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableVarDecimal'");
  }
  @Override
  public FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'VarDecimal'");
  }
  @Override
  public FieldConverter getNewRepeatedVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedVarDecimal'");
  }
  @Override
  public FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'NullableBit'");
  }
  @Override
  public FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'Bit'");
  }
  @Override
  public FieldConverter getNewRepeatedBitConverter(int fieldId, String fieldName, FieldReader reader) {
    throw new UnsupportedOperationException("Doesn't support writing 'RepeatedBit'");
  }

  @Override
  public void postProcessing() throws IOException {
    // no op
  }

  @Override
  public boolean supportsField(MaterializedField field) {
    return !field.getName().equalsIgnoreCase(WriterPrel.PARTITION_COMPARATOR_FIELD);
  }
}
