/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//Functions for Trigo Math Functions
//////////////////////////////////////////////////////////////////////////////////////////////////


package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.types.TypeProtos.MinorType;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctions;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is automatically generated from MathFunc.tdd using FreeMarker.
 */

@SuppressWarnings("unused")

public class TrigoMathFunctions{
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(TrigoMathFunctions.class);

  private TrigoMathFunctions(){}



  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }

  @FunctionTemplate(name = "sin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sin(in.value);
    }
  }


  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }

  @FunctionTemplate(name = "cos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CosUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cos(in.value);
    }
  }


  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "tan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tan(in.value);
    }
  }


  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }

  @FunctionTemplate(name = "asin", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ASinUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.asin(in.value);
    }
  }


  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }

  @FunctionTemplate(name = "acos", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ACosUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.acos(in.value);
    }
  }


  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }

  @FunctionTemplate(name = "atan", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class ATanUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.atan(in.value);
    }
  }


  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }

  @FunctionTemplate(name = "sinh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SinhUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.sinh(in.value);
    }
  }


  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }

  @FunctionTemplate(name = "cosh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CoshUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.cosh(in.value);
    }
  }


  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }

  @FunctionTemplate(name = "tanh", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TanhUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = java.lang.Math.tanh(in.value);
    }
  }


  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotSmallInt implements DrillSimpleFunc {

    @Param SmallIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotTinyInt implements DrillSimpleFunc {

    @Param TinyIntHolder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotUInt1 implements DrillSimpleFunc {

    @Param UInt1Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotUInt2 implements DrillSimpleFunc {

    @Param UInt2Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotUInt4 implements DrillSimpleFunc {

    @Param UInt4Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }

  @FunctionTemplate(name = "cot", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class CotUInt8 implements DrillSimpleFunc {

    @Param UInt8Holder in;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = 1.0/java.lang.Math.tan(in.value);
    }
  }
}
