
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

/*
 * This class is generated using freemarker and the RepeatedCountFunctions.java template.
 */
public class RepeatedCountFunctions {

  private RepeatedCountFunctions() {
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedBit implements DrillSimpleFunc {

    @Param
    RepeatedBitHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedInt implements DrillSimpleFunc {

    @Param
    RepeatedIntHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedBigInt implements DrillSimpleFunc {

    @Param
    RepeatedBigIntHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedFloat4 implements DrillSimpleFunc {

    @Param
    RepeatedFloat4Holder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedFloat8 implements DrillSimpleFunc {

    @Param
    RepeatedFloat8Holder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedDate implements DrillSimpleFunc {

    @Param
    RepeatedDateHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedTimeStamp implements DrillSimpleFunc {

    @Param
    RepeatedTimeStampHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedTime implements DrillSimpleFunc {

    @Param
    RepeatedTimeHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedIntervalDay implements DrillSimpleFunc {

    @Param
    RepeatedIntervalDayHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedIntervalYear implements DrillSimpleFunc {

    @Param
    RepeatedIntervalYearHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedInterval implements DrillSimpleFunc {

    @Param
    RepeatedIntervalHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedVarChar implements DrillSimpleFunc {

    @Param
    RepeatedVarCharHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedVarBinary implements DrillSimpleFunc {

    @Param
    RepeatedVarBinaryHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedVarDecimal implements DrillSimpleFunc {

    @Param
    RepeatedVarDecimalHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedDecimal9 implements DrillSimpleFunc {

    @Param
    RepeatedDecimal9Holder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedDecimal18 implements DrillSimpleFunc {

    @Param
    RepeatedDecimal18Holder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedDecimal28Sparse implements DrillSimpleFunc {

    @Param
    RepeatedDecimal28SparseHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedDecimal38Sparse implements DrillSimpleFunc {

    @Param
    RepeatedDecimal38SparseHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedList implements DrillSimpleFunc {

    @Param
    RepeatedListHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

  @FunctionTemplate(name = "repeated_count", scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class RepeatedCountRepeatedMap implements DrillSimpleFunc {

    @Param
    RepeatedMapHolder input;
    @Output
    IntHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size();
    }
  }

}
