

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/IntervalNumericArithmetic.java template.
 */

public class IntervalFloat8Functions {


    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalFloat8MultiplyFunction implements DrillSimpleFunc {
    @Param IntervalHolder left;
    @Param Float8Holder right;
    @Output IntervalHolder out;

        public void setup() {
        }

        public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalMonths = (left.months * (double) right.value);
    fractionalDays = (left.days * (double) right.value);
    fractionalMillis = (left.milliseconds * (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.vector.DateUtilities.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class Float8IntervalMultiplyFunction implements DrillSimpleFunc {
    @Param Float8Holder right;
    @Param IntervalHolder left;
    @Output IntervalHolder out;

        public void setup() {
        }

        public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalMonths = (left.months * (double) right.value);
    fractionalDays = (left.days * (double) right.value);
    fractionalMillis = (left.milliseconds * (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.vector.DateUtilities.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
        }
    }

  @SuppressWarnings("unused")
  @FunctionTemplate(names = {"divide", "div"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class IntervalFloat8DivideFunction implements DrillSimpleFunc {
    @Param IntervalHolder left;
    @Param Float8Holder right;
    @Output IntervalHolder out;

    public void setup() {
    }

    public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalMonths = (left.months / (double) right.value);
    fractionalDays = (left.days / (double) right.value);
    fractionalMillis = (left.milliseconds / (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.vector.DateUtilities.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
    }
  }
}

