

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareVarBinaryVsVarBinary {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsVarBinaryNullHigh implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param VarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsVarBinaryNullLow implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param VarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsNullableVarBinaryNullHigh implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param NullableVarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsNullableVarBinaryNullLow implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param NullableVarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsVarBinaryNullHigh implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param VarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsVarBinaryNullLow implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param VarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsNullableVarBinaryNullHigh implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param NullableVarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsNullableVarBinaryNullLow implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param NullableVarBinaryHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp < 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp > -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.equal(
              left.buffer, left.start, left.end, right.buffer, right.start, right.end);

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsVarBinaryVsVarBinary implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarBinaryHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 0 ? 0 : 1;

      }
  }

}


 

 