

package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the CastFunctionsSrcVarLenTargetVarLen.java template.
 */

@SuppressWarnings("unused")
@FunctionTemplate(name = "castVARCHAR",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.STRING_CAST,
    nulls = NullHandling.NULL_IF_NULL)
public class CastVarBinaryVarChar implements DrillSimpleFunc{

  @Param VarBinaryHolder in;
  @Param BigIntHolder length;
  @Output VarCharHolder out;

  public void setup() {
  }

  public void eval() {


    //Do 1st scan to counter # of character in string.
    int charCount = org.apache.drill.exec.expr.fn.impl.StringFunctionUtil.getUTF8CharLength(in.buffer, in.start, in.end);

    //if input length <= target_type length, do nothing
    //else if target length = 0, it means cast wants all the characters in the input. Do nothing.
    //else truncate based on target_type length.
    out.buffer = in.buffer;
    out.start =  in.start;
    if (charCount <= length.value || length.value == 0 ) {
      out.end = in.end;
    } else {
      out.end = org.apache.drill.exec.expr.fn.impl.StringFunctionUtil.getUTF8CharPosition(in.buffer, in.start, in.end, (int)length.value);
    }


  }      
}

 

