/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import java.io.File;
import org.apache.drill.yarn.client.AMRunner;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.FileUploader;
import org.apache.drill.yarn.client.StatusCommand;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class StartCommand
extends ClientCommand {
    private Config config;
    private boolean upload;
    private boolean launch;
    private boolean dryRun;

    public StartCommand(boolean upload, boolean launch) {
        this.upload = upload;
        this.launch = launch;
    }

    @Override
    public void run() throws ClientException {
        this.checkExistingApp();
        this.dryRun = this.opts.dryRun;
        this.config = DrillOnYarnConfig.config();
        FileUploader uploader = this.upload();
        if (this.launch) {
            this.launch(uploader);
        }
    }

    private void checkExistingApp() throws ClientException {
        StatusCommand.Reporter reporter;
        ApplicationId appId;
        File appIdFile = StartCommand.getAppIdFile();
        if (!appIdFile.exists()) {
            return;
        }
        try {
            System.out.println("Found app ID file: " + appIdFile.getAbsolutePath());
            appId = this.checkAppId();
            System.out.print("Checking application ID: " + appId.toString() + "...");
            YarnRMClient client = new YarnRMClient(appId);
            reporter = new StatusCommand.Reporter(client);
            reporter.getReport();
        }
        catch (ClientException e) {
            System.out.println(" Not running.");
            appIdFile.delete();
            return;
        }
        if (reporter.isStopped()) {
            System.out.println(" Completed with state " + reporter.getState());
            appIdFile.delete();
            return;
        }
        System.out.println(" Still running!");
        throw new ClientException("Error: AM already running as Application ID: " + appId);
    }

    private FileUploader upload() throws ClientException {
        FileUploader uploader = !this.config.getBoolean(DrillOnYarnConfig.LOCALIZE_DRILL) ? new FileUploader.NonLocalized(this.dryRun, this.opts.verbose) : (this.upload ? new FileUploader.UploadFiles(this.opts.force, this.dryRun, this.opts.verbose) : new FileUploader.ReuseFiles(this.dryRun, this.opts.verbose));
        ((FileUploader)uploader).run();
        return uploader;
    }

    private void launch(FileUploader uploader) throws ClientException {
        AMRunner runner = new AMRunner(this.config, this.opts.verbose, this.dryRun);
        runner.resources = uploader.resources;
        runner.remoteDrillHome = uploader.remoteDrillHome;
        runner.remoteSiteDir = uploader.remoteSiteDir;
        if (uploader.isLocalized()) {
            runner.drillArchivePath = uploader.drillArchivePath.toString();
            if (uploader.hasSiteDir()) {
                runner.siteArchivePath = uploader.siteArchivePath.toString();
            }
        }
        runner.run();
    }
}

