/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.drill.test.BaseTest;
import org.apache.drill.yarn.client.ClientContext;
import org.apache.drill.yarn.client.DrillOnYarn;
import org.junit.Assert;
import org.junit.Test;

public class TestClient
extends BaseTest {
    @Test
    public void testBasics() {
        TestContext.testInit();
        try {
            DrillOnYarn.run((String[])new String[0]);
            Assert.fail();
        }
        catch (SimulatedExitException e) {
            assert (e.exitCode == -1);
            Assert.assertTrue((boolean)TestContext.getOut().contains("Usage: "));
            TestContext.resetOutput();
        }
        try {
            DrillOnYarn.run((String[])new String[]{"bogus"});
            Assert.fail();
        }
        catch (SimulatedExitException e) {
            assert (e.exitCode == -1);
            Assert.assertTrue((boolean)TestContext.getOut().contains("Usage: "));
            TestContext.resetOutput();
        }
    }

    public static class TestContext
    extends ClientContext {
        public static ByteArrayOutputStream captureOut = new ByteArrayOutputStream();
        public static ByteArrayOutputStream captureErr = new ByteArrayOutputStream();

        public static void testInit() {
            TestContext.init((ClientContext)new TestContext());
            TestContext.resetOutput();
        }

        public void exit(int exitCode) {
            throw new SimulatedExitException(exitCode);
        }

        public static void resetOutput() {
            try {
                out.flush();
                captureOut.reset();
                out = new PrintStream((OutputStream)captureOut, true, "UTF-8");
                err.flush();
                captureErr.reset();
                err = new PrintStream((OutputStream)captureErr, true, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getOut() {
            out.flush();
            try {
                return captureOut.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getErr() {
            out.flush();
            try {
                return captureErr.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class SimulatedExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public int exitCode;

        public SimulatedExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

