/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.drill.test.BaseTest;
import org.apache.drill.yarn.core.DoyConfigException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestConfig
extends BaseTest {
    @Test
    public void testLoad() throws IOException, DoyConfigException {
        DoYTestConfig doyConfig = this.initConfig("test-doy-config.conf");
        Config config = DrillOnYarnConfig.config();
        Assert.assertEquals((Object)"drill", (Object)config.getString(DrillOnYarnConfig.DRILL_ARCHIVE_KEY));
        Assert.assertEquals((Object)"/opt/drill", (Object)config.getString(DrillOnYarnConfig.DFS_APP_DIR));
        Assert.assertEquals((Object)"My-App", (Object)config.getString(DrillOnYarnConfig.APP_NAME));
        Assert.assertEquals((Object)"drillbits1", (Object)config.getString("drill.exec.cluster-id"));
        Assert.assertNull((Object)doyConfig.mockEnv.get("DRILL_HOME"));
        doyConfig.mockEnv.put("DRILL_CONF_DIR", "/drill/site");
        doyConfig.setClientPaths();
        Assert.assertEquals((Object)"/config/drill/home", (Object)doyConfig.getLocalDrillHome().getAbsolutePath());
        Assert.assertTrue((boolean)doyConfig.hasSiteDir());
        Assert.assertEquals((Object)"/drill/site", (Object)doyConfig.getLocalSiteDir().getAbsolutePath());
        doyConfig.mockEnv.put("DRILL_HOME", "/drill/home");
        doyConfig.setClientPaths();
        Assert.assertEquals((Object)"/drill/home", (Object)doyConfig.getLocalDrillHome().getAbsolutePath());
        Assert.assertTrue((boolean)config.getBoolean(DrillOnYarnConfig.LOCALIZE_DRILL));
        Assert.assertEquals((Object)"/foo/bar/drill-archive.tar.gz", (Object)config.getString(DrillOnYarnConfig.DRILL_ARCHIVE_PATH));
        Assert.assertEquals((Object)"$PWD/drill/drill-archive", (Object)doyConfig.getRemoteDrillHome());
        Assert.assertEquals((Object)"site", (Object)config.getString(DrillOnYarnConfig.SITE_ARCHIVE_KEY));
        Assert.assertEquals((Object)"$PWD/site", (Object)doyConfig.getRemoteSiteDir());
        doyConfig.mockEnv.put("DRILL_CONF_DIR", "/drill/home/conf");
        doyConfig.setClientPaths();
        Assert.assertEquals((Object)"/drill/home", (Object)doyConfig.getLocalDrillHome().getAbsolutePath());
        Assert.assertEquals((Object)"drill", (Object)config.getString("drill.exec.zk.root"));
        Assert.assertEquals((Object)"drillbits1", (Object)config.getString("drill.exec.cluster-id"));
        Assert.assertEquals((Object)"/drill/home/drill-drillbits1.appid", (Object)doyConfig.getLocalAppIdFile().getAbsolutePath());
        doyConfig.mockEnv.put("DRILL_CONF_DIR", "/var/drill/site");
        doyConfig.setClientPaths();
        Assert.assertEquals((Object)"/var/drill/drill-drillbits1.appid", (Object)doyConfig.getLocalAppIdFile().getAbsolutePath());
    }

    private DoYTestConfig initConfig(String configName) throws IOException, DoyConfigException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File configDir = new File(tempDir, "config");
        if (configDir.exists()) {
            FileUtils.forceDelete((File)configDir);
        }
        configDir.mkdirs();
        configDir.deleteOnExit();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + configName);
        File dest = new File(configDir, "drill-on-yarn.conf");
        Files.copy(in, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        in = ((Object)((Object)this)).getClass().getResourceAsStream("/test-doy-distrib.conf");
        dest = new File(configDir, "doy-distrib.conf");
        Files.copy(in, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        System.setProperty(DrillOnYarnConfig.YARN_QUEUE, "sys-queue");
        TestClassLoader cl = new TestClassLoader(((Object)((Object)this)).getClass().getClassLoader(), configDir);
        Assert.assertNotNull((Object)cl.getResource("doy-distrib.conf"));
        return new DoYTestConfig(cl, configDir);
    }

    @Test
    public void testNonLocalized() throws IOException, DoyConfigException {
        DoYTestConfig doyConfig = this.initConfig("second-test-config.conf");
        doyConfig.mockEnv.put("DRILL_CONF_DIR", "/drill/site");
        doyConfig.setClientPaths();
        Assert.assertEquals((Object)"/config/drill/home", (Object)doyConfig.getRemoteDrillHome());
        Assert.assertEquals((Object)"/config/drill/site", (Object)doyConfig.getRemoteSiteDir());
    }

    @Test
    public void testNonLocalizedNonSite() throws IOException, DoyConfigException {
        DoYTestConfig doyConfig = this.initConfig("third-test-config.conf");
        Assert.assertEquals((Object)"/config/drill/home", (Object)doyConfig.getRemoteDrillHome());
        Assert.assertNull((Object)doyConfig.getRemoteSiteDir());
    }

    private static class TestClassLoader
    extends ClassLoader {
        private File configDir;

        public TestClassLoader(ClassLoader parent, File configDir) {
            super(parent);
            this.configDir = configDir;
        }

        @Override
        protected URL findResource(String name) {
            File file = new File(this.configDir, name);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class DoYTestConfig
    extends DrillOnYarnConfig {
        protected Map<String, String> mockEnv = new HashMap<String, String>();
        protected File configDir;

        public DoYTestConfig(TestClassLoader cl, File configDir) throws DoyConfigException {
            this.doLoad(cl);
            instance = this;
            this.configDir = configDir;
        }

        protected String getEnv(String key) {
            return this.mockEnv.get(key);
        }
    }
}

