/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.zk;

import org.apache.curator.test.TestingServer;
import org.apache.drill.yarn.appMaster.AMRegistrar;
import org.apache.drill.yarn.zk.ZKClusterCoordinatorDriver;
import org.junit.Assert;
import org.junit.Test;

public class TestAmRegistration {
    private static final String TEST_CLUSTER_ID = "drillbits";
    private static final String TEST_ZK_ROOT = "drill";
    private static final String TEST_AM_HOST = "localhost";
    private static final int TEST_AM_PORT = 8048;
    private static final String TEST_APP_ID = "Application_001";
    private static final String PROBE_AM_HOST = "somehost";
    private static final String PROBE_APP_ID = "Application_002";
    private static final int PROBE_AM_PORT = 8049;
    private static final String PROBE_CLUSTER_ID = "second";
    private static final String PROBE_ZK_ROOT = "myRoot";

    @Test
    public void testAMRegistry() throws Exception {
        try (TestingServer server = new TestingServer();){
            server.start();
            String connStr = server.getConnectString();
            ZKClusterCoordinatorDriver driver = new ZKClusterCoordinatorDriver().setConnect(connStr, TEST_ZK_ROOT, TEST_CLUSTER_ID).build();
            driver.register(TEST_AM_HOST, 8048, TEST_APP_ID);
            ZKClusterCoordinatorDriver driver2 = new ZKClusterCoordinatorDriver().setConnect(connStr, TEST_ZK_ROOT, TEST_CLUSTER_ID).build();
            try {
                driver.register(PROBE_AM_HOST, 8049, PROBE_APP_ID);
                Assert.fail();
            }
            catch (AMRegistrar.AMRegistrationException e) {
                String msg = e.getMessage();
                Assert.assertTrue((boolean)msg.contains("Application Master already exists"));
                Assert.assertTrue((boolean)msg.contains(" drill/drillbits "));
                Assert.assertTrue((boolean)msg.contains(" host: localhost"));
                Assert.assertTrue((boolean)msg.contains(" Application ID: Application_001"));
            }
            driver2.close();
            driver2 = new ZKClusterCoordinatorDriver().setConnect(connStr, TEST_ZK_ROOT, PROBE_CLUSTER_ID).build();
            try {
                driver2.register(PROBE_AM_HOST, 8049, PROBE_APP_ID);
            }
            catch (AMRegistrar.AMRegistrationException e) {
                Assert.fail((String)"Registration should be OK");
            }
            driver2.close();
            driver2 = new ZKClusterCoordinatorDriver().setConnect(connStr, PROBE_ZK_ROOT, TEST_CLUSTER_ID).build();
            try {
                driver2.register(PROBE_AM_HOST, 8049, PROBE_APP_ID);
            }
            catch (AMRegistrar.AMRegistrationException e) {
                Assert.fail((String)"Registration should be OK");
            }
            driver2.close();
            driver.close();
            driver2 = new ZKClusterCoordinatorDriver().setConnect(connStr, TEST_ZK_ROOT, TEST_CLUSTER_ID).build();
            try {
                driver2.register(PROBE_AM_HOST, 8049, PROBE_APP_ID);
            }
            catch (AMRegistrar.AMRegistrationException e) {
                Assert.fail((String)"Registration should be OK");
            }
            driver2.close();
            server.stop();
        }
    }
}

