/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import java.io.IOException;
import org.apache.drill.yarn.core.AppSpec;
import org.apache.drill.yarn.core.YarnClientException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;

public class YarnRMClient {
    private YarnConfiguration conf;
    private YarnClient yarnClient;
    private ApplicationId appId;
    private YarnClientApplication app;

    public YarnRMClient() {
        this(new YarnConfiguration());
    }

    public YarnRMClient(ApplicationId appId) {
        this();
        this.appId = appId;
    }

    public YarnRMClient(YarnConfiguration conf) {
        this.conf = conf;
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init((Configuration)conf);
        this.yarnClient.start();
    }

    public GetNewApplicationResponse createAppMaster() throws YarnClientException {
        try {
            this.app = this.yarnClient.createApplication();
        }
        catch (IOException | YarnException e) {
            throw new YarnClientException("Create application failed", (Exception)e);
        }
        GetNewApplicationResponse response = this.app.getNewApplicationResponse();
        this.appId = response.getApplicationId();
        return response;
    }

    public void submitAppMaster(AppSpec spec) throws YarnClientException {
        ApplicationSubmissionContext appContext;
        if (this.app == null) {
            throw new IllegalStateException("call createAppMaster( ) first");
        }
        try {
            appContext = spec.createAppLaunchContext(this.conf, this.app);
        }
        catch (IOException e) {
            throw new YarnClientException("Create app launch context failed", e);
        }
        try {
            this.yarnClient.submitApplication(appContext);
        }
        catch (IOException | YarnException e) {
            throw new YarnClientException("Submit application failed", (Exception)e);
        }
    }

    public ApplicationId getAppId() {
        return this.appId;
    }

    public ApplicationReport getAppReport() throws YarnClientException {
        try {
            return this.yarnClient.getApplicationReport(this.appId);
        }
        catch (IOException | YarnException e) {
            throw new YarnClientException("Get application report failed", (Exception)e);
        }
    }

    public ApplicationAttemptId waitForStart() throws YarnClientException {
        ApplicationAttemptId attemptId;
        YarnApplicationState appState;
        while (true) {
            ApplicationReport appReport = this.getAppReport();
            appState = appReport.getYarnApplicationState();
            attemptId = appReport.getCurrentApplicationAttemptId();
            if (appState != YarnApplicationState.NEW && appState != YarnApplicationState.NEW_SAVING && appState != YarnApplicationState.SUBMITTED) break;
            System.out.println("App State: " + appState);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (appState != YarnApplicationState.ACCEPTED) {
            throw new YarnClientException("Application start failed with status " + appState);
        }
        return attemptId;
    }

    public void waitForCompletion() throws YarnClientException {
        ApplicationReport appReport;
        YarnApplicationState appState;
        while ((appState = (appReport = this.getAppReport()).getYarnApplicationState()) != YarnApplicationState.FINISHED && appState != YarnApplicationState.KILLED && appState != YarnApplicationState.FAILED) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("Application " + this.appId + " finished with state " + appState + " at " + appReport.getFinishTime());
    }

    public Token<AMRMTokenIdentifier> getAMRMToken() throws YarnClientException {
        try {
            return this.yarnClient.getAMRMToken(this.appId);
        }
        catch (IOException | YarnException e) {
            throw new YarnClientException("Get AM/RM token failed", (Exception)e);
        }
    }

    public String[] getYarnAppClassPath() {
        return this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH);
    }

    public void killApplication() throws YarnClientException {
        try {
            this.yarnClient.killApplication(this.appId);
        }
        catch (IOException | YarnException e) {
            throw new YarnClientException("Kill failed for application: " + this.appId.toString());
        }
    }
}

