/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import org.apache.drill.common.expression.SchemaPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SchemaPathTest {
    SchemaPathTest() {
    }

    @Test
    void testUnIndexedWithOutArray() {
        SchemaPath oneElementSchema = SchemaPath.parseFromString((String)"`a`");
        Assertions.assertEquals((Object)oneElementSchema, (Object)oneElementSchema.getUnIndexed(), (String)"Schema path should match");
        SchemaPath severalElementsSchema = SchemaPath.parseFromString((String)"`a`.`b`.`c`");
        Assertions.assertEquals((Object)severalElementsSchema, (Object)severalElementsSchema.getUnIndexed(), (String)"Schema path should match");
    }

    @Test
    void testUnIndexedEndingWithArray() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0]");
        Assertions.assertEquals((Object)SchemaPath.parseFromString((String)"`a`.`b`"), (Object)schemaPath.getUnIndexed(), (String)"Schema path should match");
    }

    @Test
    void testUnIndexedArrayInTheMiddle() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0].`c`.`d`");
        Assertions.assertEquals((Object)SchemaPath.parseFromString((String)"`a`.`b`.`c`.`d`"), (Object)schemaPath.getUnIndexed(), (String)"Schema path should match");
    }

    @Test
    void testUnIndexedMultipleArrays() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0][1].`c`.`d`[2][0]");
        Assertions.assertEquals((Object)SchemaPath.parseFromString((String)"`a`.`b`.`c`.`d`"), (Object)schemaPath.getUnIndexed(), (String)"Schema path should match");
    }

    @Test
    void testCompoundPathN() {
        SchemaPath schemaPath = SchemaPath.getCompoundPath((int)3, (String[])new String[]{"a", "b", "c", "d", "e"});
        Assertions.assertEquals((Object)SchemaPath.getCompoundPath((String[])new String[]{"a", "b", "c"}), (Object)schemaPath, (String)"Schema path should match");
    }
}

