/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.fn.FuncHolder;
import org.apache.drill.common.expression.visitors.ExprVisitor;

public abstract class FunctionHolderExpression
extends LogicalExpressionBase {
    public final ImmutableList<LogicalExpression> args;
    public final String nameUsed;
    private FieldReference fieldReference;

    public FunctionHolderExpression(String nameUsed, ExpressionPosition pos, List<LogicalExpression> args) {
        super(pos);
        this.nameUsed = nameUsed;
        this.args = args == null ? ImmutableList.of() : ImmutableList.copyOf(args);
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitFunctionHolderExpression(this, value);
    }

    public String getName() {
        return this.nameUsed;
    }

    public abstract boolean argConstantOnly(int var1);

    public abstract boolean isAggregating();

    public abstract boolean isRandom();

    public abstract FunctionHolderExpression copy(List<LogicalExpression> var1);

    public abstract FuncHolder getHolder();

    public FieldReference getFieldReference() {
        return this.fieldReference;
    }

    public void setFieldReference(FieldReference fieldReference) {
        this.fieldReference = fieldReference;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(", ").append(this.nameUsed).append("(");
        boolean first = true;
        for (LogicalExpression arg : this.args) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append(arg.toString());
        }
        return buf.append("]").toString();
    }
}

