/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="lateral-join")
public class LateralJoin
extends LogicalOperatorBase {
    private final LogicalOperator left;
    private final LogicalOperator right;

    @JsonCreator
    public LateralJoin(@JsonProperty(value="left") LogicalOperator left, @JsonProperty(value="right") LogicalOperator right) {
        this.left = left;
        this.right = right;
        left.registerAsSubscriber(this);
        right.registerAsSubscriber(this);
    }

    public LogicalOperator getLeft() {
        return this.left;
    }

    public LogicalOperator getRight() {
        return this.right;
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.forArray((Object[])new LogicalOperator[]{this.getLeft(), this.getRight()});
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitLateralJoin(this, value);
    }
}

