/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.graph;

import java.util.Collection;
import java.util.List;
import org.apache.drill.common.graph.AdjacencyList;
import org.apache.drill.common.graph.GraphValue;
import org.apache.drill.common.logical.UnexpectedOperatorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph<G extends GraphValue<G>, R extends G, T extends G> {
    static final Logger logger = LoggerFactory.getLogger(Graph.class);
    private AdjacencyList<G> adjList;
    private final List<R> roots;
    private final List<T> leaves;

    public Graph(List<G> operators, Class<R> root, Class<T> leaf) {
        this.adjList = AdjacencyList.newInstance(operators);
        this.roots = this.checkOperatorType(this.adjList.getRootNodes(), root, String.format("Root nodes must be a subclass of %s.", root.getSimpleName()));
        this.leaves = this.checkOperatorType(this.adjList.getLeafNodes(), leaf, String.format("Leaf nodes must be a subclass of %s.", leaf.getSimpleName()));
    }

    private <O extends G> List<O> checkOperatorType(Collection<G> ops, Class<O> classIdentifier, String error) {
        for (GraphValue o : ops) {
            if (classIdentifier.isAssignableFrom(o.getClass())) continue;
            throw new UnexpectedOperatorType(o, error);
        }
        return (List)ops;
    }

    public AdjacencyList<G> getAdjList() {
        return this.adjList;
    }

    public Collection<R> getRoots() {
        return this.roots;
    }

    public Collection<T> getLeaves() {
        return this.leaves;
    }

    public static <G extends GraphValue<G>, R extends G, T extends G> Graph<G, R, T> newGraph(List<G> operators, Class<R> root, Class<T> leaf) {
        return new Graph<G, R, T>(operators, root, leaf);
    }
}

