/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalPlanPersistence {
    private static final Logger logger = LoggerFactory.getLogger(LogicalPlanPersistence.class);
    private final ObjectMapper mapper;

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult) {
        this(conf, scanResult, new ObjectMapper());
    }

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult, ObjectMapper mapper) {
        this.mapper = mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, (JsonDeserializer)new LogicalExpression.De(conf)).addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De());
        InjectableValues.Std injectables = new InjectableValues.Std().addValue(DrillConfig.class, (Object)conf);
        mapper.setInjectableValues((InjectableValues)injectables);
        mapper.registerModule((Module)deserModule);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, LogicalOperator.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, StoragePluginConfig.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, FormatPluginConfig.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, CredentialsProvider.class));
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private <T> void registerSubtypes(Set<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            this.mapper.registerSubtypes(new Class[]{clazz});
        }
    }

    public static <T> Set<Class<? extends T>> getSubTypes(ScanResult classpathScan, Class<T> parent) {
        Set subclasses = classpathScan.getImplementations(parent);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder().append("Found ").append(subclasses.size()).append(" ").append(parent.getSimpleName()).append(" subclasses:\n");
            for (Class c : subclasses) {
                sb.append('\t');
                sb.append(c.getName());
                sb.append('\n');
            }
            logger.debug(sb.toString());
        }
        return subclasses;
    }
}

