/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.storage;

import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.config.LogicalPlanPersistence;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.test.DrillTest;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckStorageConfig
extends DrillTest {
    static final Logger logger = LoggerFactory.getLogger(CheckStorageConfig.class);

    @Test
    public void ensureStorageEnginePickup() {
        DrillConfig config = DrillConfig.create();
        ScanResult scan = ClassPathScanner.fromPrescan((DrillConfig)config);
        Set engines = scan.getImplementations(StoragePluginConfig.class);
        Assert.assertEquals((long)engines.size(), (long)1L);
    }

    @Test
    public void checkPlanParsing() throws Exception {
        DrillConfig config = DrillConfig.create();
        ScanResult scan = ClassPathScanner.fromPrescan((DrillConfig)config);
        LogicalPlan plan = LogicalPlan.parse((LogicalPlanPersistence)new LogicalPlanPersistence(config, scan), (String)DrillFileUtils.getResourceAsString((String)"/storage_engine_plan.json"));
    }
}

