/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.parser;

import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.parser.LogicalExpressionParser;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TreeTest
extends DrillTest {
    TreeTest() {
    }

    @Test
    void escapeStringLiteral() {
        String expr = "func(`identifier`, '\\\\d+', 0, 'fjds')";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    void escapeQuotedIdentifier() {
        String expr = "`a\\\\b` + `c'd`";
        this.testExpressionParsing(expr, "add(`a\\\\b`, `c'd`)");
    }

    @Test
    void testIfWithCase() {
        this.testExpressionParsing("if ($F1) then case when (_MAP.R_NAME = 'AFRICA') then 2 else 4 end else if(4==3) then 1 else if(x==3) then 7 else (if(2==1) then 6 else 4 end) end", "( if (equal(`x`, 3)  ) then (7 )  else ( ( if (equal(2, 1)  ) then (6 )  else (4 )  end  )  )  end  )");
    }

    @Test
    void testAdd() {
        this.testExpressionParsing("2+2", "add(2, 2)");
    }

    @Test
    void testIf() {
        this.testExpressionParsing("if ('blue.red') then 'orange' else if (false) then 1 else 0 end", "( if (false ) then (1 )  else (0 )  end  )");
    }

    @Test
    void testQuotedIdentifier() {
        String expr = "`hello friend`.`goodbye`";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    void testSpecialQuoted() {
        this.testExpressionParsing("`*0` + `*` ", "add(`*0`, `*`)");
    }

    @Test
    void testQuotedIdentifier2() {
        this.testExpressionParsing("`hello friend`.goodbye", "`hello friend`.`goodbye`");
    }

    @Test
    void testComplexIdentifier() {
        this.testExpressionParsing("goodbye[4].`hello`", "`goodbye`[4].`hello`");
    }

    @Test
    void testCastToBooleanExpr() {
        String expr = "cast( (cast( (`bool_col` ) as VARCHAR(100) ) ) as BIT )";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    void testComments() {
        this.testExpressionParsing("cast /* block comment */ ( // single comment\n1 as int)", "cast( (1 ) as INT )");
    }

    @Test
    void testParsingException() {
        ExpressionParsingException exception = (ExpressionParsingException)Assertions.assertThrows(ExpressionParsingException.class, () -> this.testExpressionParsing("cast(1 as i)", ""));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"mismatched input 'i' expecting"));
    }

    @Test
    void testFunctionCallWithoutParams() {
        String expr = "now()";
        this.testExpressionParsing(expr, expr);
    }

    private void testExpressionParsing(String expr, String expected) {
        LogicalExpression e1 = LogicalExpressionParser.parse((String)expr);
        String newStringExpr = this.serializeExpression(e1);
        Assertions.assertEquals((Object)expected, (Object)newStringExpr.trim());
        LogicalExpressionParser.parse((String)newStringExpr);
    }

    private String serializeExpression(LogicalExpression expr) {
        ExpressionStringBuilder b = new ExpressionStringBuilder();
        StringBuilder sb = new StringBuilder();
        expr.accept((ExprVisitor)b, (Object)sb);
        return sb.toString();
    }
}

