/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OrderTest {
    @Test
    public void test_Ordering_roundTripAscAndNullsFirst() {
        Order.Ordering src = new Order.Ordering(RelFieldCollation.Direction.ASCENDING, null, RelFieldCollation.NullDirection.FIRST);
        Order.Ordering reconstituted = new Order.Ordering(src.getDirection(), (LogicalExpression)null, src.getNullDirection());
        Assert.assertThat((Object)reconstituted.getDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.Direction.ASCENDING));
        Assert.assertThat((Object)reconstituted.getNullDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.NullDirection.FIRST));
    }

    @Test
    public void test_Ordering_roundTripDescAndNullsLast() {
        Order.Ordering src = new Order.Ordering(RelFieldCollation.Direction.DESCENDING, null, RelFieldCollation.NullDirection.LAST);
        Order.Ordering reconstituted = new Order.Ordering(src.getDirection(), (LogicalExpression)null, src.getNullDirection());
        Assert.assertThat((Object)reconstituted.getDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.Direction.DESCENDING));
        Assert.assertThat((Object)reconstituted.getNullDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.NullDirection.LAST));
    }

    @Test
    public void test_Ordering_roundTripDescAndNullsUnspecified() {
        Order.Ordering src = new Order.Ordering(RelFieldCollation.Direction.DESCENDING, null, RelFieldCollation.NullDirection.UNSPECIFIED);
        Order.Ordering reconstituted = new Order.Ordering(src.getDirection(), (LogicalExpression)null, src.getNullDirection());
        Assert.assertThat((Object)reconstituted.getDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.Direction.DESCENDING));
        Assert.assertThat((Object)reconstituted.getNullDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.NullDirection.UNSPECIFIED));
    }

    @Test(expected=DrillRuntimeException.class)
    public void test_Ordering_garbageOrderRejected() {
        new Order.Ordering("AS CE ND IN G", null, null);
    }

    @Test(expected=DrillRuntimeException.class)
    public void test_Ordering_garbageNullOrderingRejected() {
        new Order.Ordering(null, null, "HIGH");
    }

    @Test
    public void testOrdering_nullStrings() {
        Order.Ordering ordering = new Order.Ordering((String)null, (LogicalExpression)null, null);
        Assert.assertThat((Object)ordering.getDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.Direction.ASCENDING));
        Assert.assertThat((Object)ordering.getNullDirection(), (Matcher)CoreMatchers.equalTo((Object)RelFieldCollation.NullDirection.UNSPECIFIED));
        Assert.assertThat((Object)ordering.getOrder(), (Matcher)CoreMatchers.equalTo((Object)"ASC"));
    }
}

