/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class SubDirTestWatcher
extends TestWatcher {
    private File baseDir;
    private boolean createAtBeginning;
    private boolean deleteAtEnd;
    private List<Path> subDirs;

    protected SubDirTestWatcher(File baseDir, boolean createAtBeginning, boolean deleteAtEnd, List<Path> subDirs) {
        this.baseDir = (File)Preconditions.checkNotNull((Object)baseDir);
        this.createAtBeginning = createAtBeginning;
        this.deleteAtEnd = deleteAtEnd;
        this.subDirs = (List)Preconditions.checkNotNull(subDirs);
        Preconditions.checkArgument((!subDirs.isEmpty() ? 1 : 0) != 0, (Object)"The list of subDirs is empty.");
    }

    protected void starting(Description description) {
        this.deleteDirs(true);
        if (!this.createAtBeginning) {
            return;
        }
        for (Path subDir : this.subDirs) {
            this.baseDir.toPath().resolve(subDir).toFile().mkdirs();
        }
    }

    protected void finished(Description description) {
        this.deleteDirs(this.deleteAtEnd);
    }

    protected void failed(Throwable e, Description description) {
        this.deleteDirs(this.deleteAtEnd);
    }

    private void deleteDirs(boolean delete) {
        if (!delete) {
            return;
        }
        for (Path subDir : this.subDirs) {
            FileUtils.deleteQuietly((File)this.baseDir.toPath().resolve(subDir).toFile());
        }
    }

    public static class Builder {
        private File baseDir;
        private boolean createAtBeginning = true;
        private boolean deleteAtEnd = true;
        private List<Path> subDirs = Lists.newArrayList();

        public Builder(File baseDir) {
            this.baseDir = (File)Preconditions.checkNotNull((Object)baseDir);
        }

        public Builder setCreateAtBeginning(boolean createAtBeginning) {
            this.createAtBeginning = createAtBeginning;
            return this;
        }

        public Builder setDeleteAtEnd(boolean deleteAtEnd) {
            this.deleteAtEnd = deleteAtEnd;
            return this;
        }

        public Builder addSubDir(Path subDir) {
            Preconditions.checkNotNull((Object)subDir);
            this.subDirs.add(subDir);
            return this;
        }

        public SubDirTestWatcher build() {
            Preconditions.checkState((!this.subDirs.isEmpty() ? 1 : 0) != 0, (Object)"The list of subDirs is empty.");
            return new SubDirTestWatcher(this.baseDir, this.createAtBeginning, this.deleteAtEnd, this.subDirs);
        }
    }
}

