/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.drill.exec.proto.UserProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrillProperties
extends Properties {
    private static final Logger logger = LoggerFactory.getLogger(DrillProperties.class);
    public static final String ZOOKEEPER_CONNECTION = "zk";
    public static final String DRILLBIT_CONNECTION = "drillbit";
    public static final String TRIES = "tries";
    public static final String SCHEMA = "schema";
    public static final String MULTIPLEX = "multiplex";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String IMPERSONATION_TARGET = "impersonation_target";
    public static final String AUTH_MECHANISM = "auth";
    public static final String SERVICE_PRINCIPAL = "principal";
    public static final String SERVICE_NAME = "service_name";
    public static final String SERVICE_HOST = "service_host";
    public static final String REALM = "realm";
    public static final String KEYTAB = "keytab";
    public static final String SASL_ENCRYPT = "sasl_encrypt";
    @VisibleForTesting
    public static final String TEST_SASL_LEVEL = "test_sasl_level";
    public static final String KERBEROS_FROM_SUBJECT = "from_subject";
    @Deprecated
    public static final String QUOTING_IDENTIFIERS = "quoting_identifiers";
    public static final String ENABLE_TLS = "enableTLS";
    public static final String TLS_PROTOCOL = "TLSProtocol";
    public static final String TRUSTSTORE_TYPE = "trustStoreType";
    public static final String TRUSTSTORE_PATH = "trustStorePath";
    public static final String TRUSTSTORE_PASSWORD = "trustStorePassword";
    public static final String DISABLE_HOST_VERIFICATION = "disableHostVerification";
    public static final String DISABLE_CERT_VERIFICATION = "disableCertificateVerification";
    public static final String TLS_HANDSHAKE_TIMEOUT = "TLSHandshakeTimeout";
    public static final String TLS_PROVIDER = "TLSProvider";
    public static final String USE_SYSTEM_TRUSTSTORE = "useSystemTrustStore";
    public static final String USE_MAPR_SSL_CONFIG = "useMapRSSLConfig";
    @Deprecated
    public static final String QUERY_TAGS = "queryTags";
    public static final ImmutableSet<String> ALLOWED_BY_CLIENT = ImmutableSet.of((Object)"zk", (Object)"drillbit", (Object)"tries", (Object)"schema", (Object)"user", (Object)"password", (Object[])new String[]{"impersonation_target", "auth", "principal", "service_name", "service_host", "realm", "keytab", "from_subject", "enableTLS", "TLSProtocol", "trustStoreType", "trustStorePath", "trustStorePassword", "disableHostVerification", "disableCertificateVerification", "TLSHandshakeTimeout", "TLSProvider", "useSystemTrustStore", "queryTags"});
    public static final ImmutableSet<String> ACCEPTED_BY_SERVER = ImmutableSet.of((Object)"user", (Object)"password", (Object)"schema", (Object)"impersonation_target", (Object)"quoting_identifiers", (Object)"queryTags", (Object[])new String[0]);

    private DrillProperties() {
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key.toLowerCase(), value);
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.toLowerCase());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key.toLowerCase(), defaultValue);
    }

    public void merge(Properties overrides) {
        if (overrides == null) {
            return;
        }
        for (String key : overrides.stringPropertyNames()) {
            this.setProperty(key.toLowerCase(), overrides.getProperty(key));
        }
    }

    public void merge(Map<String, String> overrides) {
        if (overrides == null) {
            return;
        }
        for (String key : overrides.keySet()) {
            this.setProperty(key.toLowerCase(), overrides.get(key));
        }
    }

    public Map<String, String> stringPropertiesAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String property : this.stringPropertyNames()) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    public UserProtos.UserProperties serializeForServer() {
        UserProtos.UserProperties.Builder propsBuilder = UserProtos.UserProperties.newBuilder();
        for (String key : this.stringPropertyNames()) {
            propsBuilder.addProperties(UserProtos.Property.newBuilder().setKey(key).setValue(this.getProperty(key)).build());
        }
        return propsBuilder.build();
    }

    public static DrillProperties createFromProperties(UserProtos.UserProperties userProperties, boolean addOnlyKnownServerProperties) {
        DrillProperties properties = new DrillProperties();
        for (UserProtos.Property property : userProperties.getPropertiesList()) {
            String key = property.getKey().toLowerCase();
            if (!addOnlyKnownServerProperties || ACCEPTED_BY_SERVER.contains((Object)key)) {
                properties.setProperty(key, property.getValue());
                continue;
            }
            logger.trace("Server does not recognize property: {}", (Object)key);
        }
        return properties;
    }

    public static DrillProperties createFromProperties(Properties properties) {
        DrillProperties drillProperties = new DrillProperties();
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                String lowerCaseKey = key.toLowerCase();
                drillProperties.setProperty(lowerCaseKey, properties.getProperty(key));
            }
        }
        return drillProperties;
    }

    public static DrillProperties createEmpty() {
        return new DrillProperties();
    }
}

