/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import org.apache.drill.common.Version;
import org.apache.drill.test.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestVersion
extends BaseTest {
    private final Version v1 = new Version("1.2.3-SNAPSHOT", 1, 2, 3, 0, "SNAPSHOT");
    private final Version v2 = new Version("2.1.4", 2, 1, 4, 0, "");
    private final Version v3 = new Version("3.1.5-2-BUGFIX", 3, 1, 5, 2, "BUGFIX");
    private final Version v4 = new Version("1.2.3-snapshot", 1, 2, 3, 0, "snapshot");
    private final Version v5 = new Version("1.2.3", 1, 2, 3, 0, "");

    @Test
    public void testSnapshotVersion() {
        Version version = new Version("1.2.3-SNAPSHOT", 1, 2, 3, 0, "SNAPSHOT");
        Assert.assertEquals((Object)"1.2.3-SNAPSHOT", (Object)version.getVersion());
        Assert.assertEquals((long)1L, (long)version.getMajorVersion());
        Assert.assertEquals((long)2L, (long)version.getMinorVersion());
        Assert.assertEquals((long)3L, (long)version.getPatchVersion());
        Assert.assertEquals((long)0L, (long)version.getBuildNumber());
        Assert.assertEquals((Object)"SNAPSHOT", (Object)version.getQualifier());
    }

    @Test
    public void testReleaseVersion() {
        Version version = new Version("2.1.4", 2, 1, 4, 0, "");
        Assert.assertEquals((Object)"2.1.4", (Object)version.getVersion());
        Assert.assertEquals((long)2L, (long)version.getMajorVersion());
        Assert.assertEquals((long)1L, (long)version.getMinorVersion());
        Assert.assertEquals((long)4L, (long)version.getPatchVersion());
        Assert.assertEquals((long)0L, (long)version.getBuildNumber());
        Assert.assertEquals((Object)"", (Object)version.getQualifier());
    }

    @Test
    public void testBuildNumberVersion() {
        Version version = new Version("3.1.5-2-BUGFIX", 3, 1, 5, 2, "BUGFIX");
        Assert.assertEquals((Object)"3.1.5-2-BUGFIX", (Object)version.getVersion());
        Assert.assertEquals((long)3L, (long)version.getMajorVersion());
        Assert.assertEquals((long)1L, (long)version.getMinorVersion());
        Assert.assertEquals((long)5L, (long)version.getPatchVersion());
        Assert.assertEquals((long)2L, (long)version.getBuildNumber());
        Assert.assertEquals((Object)"BUGFIX", (Object)version.getQualifier());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.v1, (Object)this.v1);
        Assert.assertNotEquals((Object)this.v1, (Object)this.v2);
        Assert.assertNotEquals((Object)this.v1, (Object)this.v3);
        Assert.assertEquals((Object)this.v1, (Object)this.v4);
        Assert.assertNotEquals((Object)this.v1, (Object)this.v5);
        Assert.assertNotEquals((Object)this.v1, null);
        Assert.assertNotEquals((Object)this.v1, (Object)new Object());
    }

    @Test
    public void testHashcode() {
        Assert.assertEquals((long)this.v1.hashCode(), (long)this.v1.hashCode());
        Assert.assertNotEquals((long)this.v1.hashCode(), (long)this.v2.hashCode());
        Assert.assertNotEquals((long)this.v1.hashCode(), (long)this.v3.hashCode());
        Assert.assertEquals((long)this.v1.hashCode(), (long)this.v4.hashCode());
        Assert.assertNotEquals((long)this.v1.hashCode(), (long)this.v5.hashCode());
    }

    @Test
    public void testCompareTo() {
        Assert.assertTrue((this.v1.compareTo(this.v1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.v1.compareTo(this.v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.v1.compareTo(this.v3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.v1.compareTo(this.v4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.v1.compareTo(this.v5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.v1.compareTo(new Version("1.2", 1, 2, 0, 0, "")) > 0 ? 1 : 0) != 0);
    }
}

