/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.collections;

import java.util.Map;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ImmutableEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    public ImmutableEntry(K key, V value) {
        this.key = Preconditions.checkNotNull(key, (Object)"key is required");
        this.value = Preconditions.checkNotNull(value, (Object)"value is required");
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("entry is immutable");
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ImmutableEntry && other.getClass() == this.getClass()) {
            ImmutableEntry entry = (ImmutableEntry)other;
            return Objects.equal(this.key, entry.key) && Objects.equal(this.value, entry.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }
}

