/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.Keyword;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Extract
extends AbstractField<Integer> {
    private static final long serialVersionUID = 3748640920856031034L;
    private final Field<?> field;
    private final DatePart datePart;

    Extract(Field<?> field, DatePart datePart) {
        super(Names.N_EXTRACT, SQLDataType.INTEGER);
        this.field = field;
        this.datePart = datePart;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                switch (this.datePart) {
                    case YEAR: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%Y', ").visit(this.field).sql(')');
                        return;
                    }
                    case MONTH: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%m', ").visit(this.field).sql(')');
                        return;
                    }
                    case DAY: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%d', ").visit(this.field).sql(')');
                        return;
                    }
                    case HOUR: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%H', ").visit(this.field).sql(')');
                        return;
                    }
                    case MINUTE: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%M', ").visit(this.field).sql(')');
                        return;
                    }
                    case SECOND: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%S', ").visit(this.field).sql(')');
                        return;
                    }
                    case EPOCH: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%s', ").visit(this.field).sql(')');
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(Extract.dowSun0ToISO(DSL.function("strftime", SQLDataType.INTEGER, DSL.inline("%w"), this.field)));
                        return;
                    }
                    case DAY_OF_WEEK: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%w', ").visit(this.field).sql(") + ").visit(DSL.one());
                        return;
                    }
                    case DAY_OF_YEAR: {
                        ctx.visit(Keywords.F_STRFTIME).sql("('%j', ").visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case DERBY: {
                switch (this.datePart) {
                    case YEAR: {
                        ctx.visit(Keywords.K_YEAR).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case MONTH: {
                        ctx.visit(Keywords.K_MONTH).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case DAY: {
                        ctx.visit(Keywords.K_DAY).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case HOUR: {
                        ctx.visit(Keywords.K_HOUR).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case MINUTE: {
                        ctx.visit(Keywords.K_MINUTE).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case SECOND: {
                        ctx.visit(Keywords.K_SECOND).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case MARIADB: 
            case MYSQL: {
                switch (this.datePart) {
                    case DAY_OF_WEEK: {
                        ctx.visit(Keywords.F_DAYOFWEEK).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case DAY_OF_YEAR: {
                        ctx.visit(DSL.keyword("dayofyear")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case EPOCH: {
                        ctx.visit(DSL.keyword("unix_timestamp")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(DSL.keyword("weekday")).sql('(').visit(this.field).sql(") + 1");
                        return;
                    }
                    case QUARTER: {
                        ctx.visit(this.datePart.toKeyword()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case POSTGRES: {
                switch (this.datePart) {
                    case DAY_OF_WEEK: {
                        ctx.sql('(');
                        this.acceptNativeFunction(ctx, DSL.keyword("dow"));
                        ctx.sql(" + 1)");
                        return;
                    }
                    case DAY_OF_YEAR: {
                        this.acceptNativeFunction(ctx, DSL.keyword("doy"));
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        this.acceptNativeFunction(ctx, DSL.keyword("isodow"));
                        return;
                    }
                    case MILLISECOND: {
                        this.acceptNativeFunction(ctx, DSL.keyword("milliseconds"));
                        return;
                    }
                    case MICROSECOND: {
                        this.acceptNativeFunction(ctx, DSL.keyword("microseconds"));
                        return;
                    }
                    case QUARTER: 
                    case CENTURY: 
                    case DECADE: 
                    case MILLENNIUM: 
                    case TIMEZONE: {
                        this.acceptNativeFunction(ctx);
                        return;
                    }
                }
                break;
            }
            case HSQLDB: {
                switch (this.datePart) {
                    case EPOCH: {
                        ctx.visit(DSL.keyword("unix_timestamp")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(Extract.dowSun1ToISO(DSL.field("{extract}({day_of_week from} {0})", SQLDataType.INTEGER, this.field)));
                        return;
                    }
                    case QUARTER: 
                    case WEEK: {
                        ctx.visit(this.datePart.toKeyword()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case H2: {
                switch (this.datePart) {
                    case QUARTER: {
                        ctx.visit(this.datePart.toKeyword()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case WEEK: {
                        ctx.visit(DSL.keyword("iso_week")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
            }
        }
        this.acceptDefaultEmulation(ctx);
    }

    private static final Field<Integer> dowISOToSun1(Field<Integer> dow) {
        return dow.mod(DSL.inline(7)).add(DSL.one());
    }

    private static final Field<Integer> dowSun1ToISO(Field<Integer> dow) {
        return dow.add(DSL.inline(5)).mod(DSL.inline(7)).add(DSL.one());
    }

    private static final Field<Integer> dowSun0ToISO(Field<Integer> dow) {
        return dow.add(DSL.inline(6)).mod(DSL.inline(7)).add(DSL.one());
    }

    private final void acceptDefaultEmulation(Context<?> ctx) {
        switch (this.datePart) {
            case DECADE: {
                ctx.visit(Tools.castIfNeeded(DSL.year(this.field).div(DSL.inline(10)), SQLDataType.INTEGER));
                break;
            }
            case CENTURY: {
                ctx.visit(Tools.castIfNeeded(DSL.sign(DSL.year(this.field)).mul(DSL.abs(DSL.year(this.field)).add(DSL.inline(99))).div(DSL.inline(100)), SQLDataType.INTEGER));
                break;
            }
            case MILLENNIUM: {
                ctx.visit(Tools.castIfNeeded(DSL.sign(DSL.year(this.field)).mul(DSL.abs(DSL.year(this.field)).add(DSL.inline(999))).div(DSL.inline(1000)), SQLDataType.INTEGER));
                break;
            }
            case QUARTER: {
                ctx.visit(DSL.month(this.field).add(DSL.inline(2)).div(DSL.inline(3)));
                break;
            }
            case TIMEZONE: {
                ctx.visit(DSL.extract(this.field, DatePart.TIMEZONE_HOUR).mul(DSL.inline(3600)).add(DSL.extract(this.field, DatePart.TIMEZONE_MINUTE).mul(DSL.inline(60))));
                break;
            }
            default: {
                this.acceptNativeFunction(ctx);
            }
        }
    }

    private final void acceptNativeFunction(Context<?> ctx) {
        this.acceptNativeFunction(ctx, this.datePart.toKeyword());
    }

    private final void acceptNativeFunction(Context<?> ctx, Keyword keyword) {
        ctx.visit(Keywords.F_EXTRACT).sql('(').visit(keyword).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.field).sql(')');
    }
}

