/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Names;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;

final class Dual
extends AbstractTable<Record> {
    private static final long serialVersionUID = -7492790780048090156L;
    private static final Table<Record> FORCED_DUAL = DSL.select(new Field[]{DSL.inline("X").as("DUMMY")}).asTable("DUAL");
    static final String DUAL_HSQLDB = "select 1 as dual from information_schema.system_users limit 1";
    static final Name DUAL_FIREBIRD = DSL.unquotedName("RDB$DATABASE");
    static final Name DUAL_CUBRID = DSL.unquotedName("db_root");
    static final Name DUAL_DERBY = DSL.unquotedName("SYSIBM", "SYSDUMMY1");
    private final boolean force;

    Dual() {
        this(false);
    }

    Dual(boolean force) {
        super(TableOptions.expression(), Names.N_DUAL, null);
        this.force = force;
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<Record> as(Name alias) {
        if (this.force) {
            return FORCED_DUAL.as(alias);
        }
        return new TableAlias<Record>(this, alias);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        if (this.force) {
            return FORCED_DUAL.as(alias, fieldAliases);
        }
        return new TableAlias<Record>(this, alias, fieldAliases);
    }

    @Override
    public boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.force) {
            ctx.visit(FORCED_DUAL);
        } else {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: 
                case SQLITE: {
                    break;
                }
                case FIREBIRD: {
                    ctx.visit(DUAL_FIREBIRD);
                    break;
                }
                case HSQLDB: {
                    ctx.sql('(').sql(DUAL_HSQLDB).sql(") as dual");
                    break;
                }
                case CUBRID: {
                    ctx.visit(DUAL_CUBRID);
                    break;
                }
                case DERBY: {
                    ctx.visit(DUAL_DERBY);
                    break;
                }
                default: {
                    ctx.sql("dual");
                }
            }
        }
    }

    @Override
    final Fields<Record> fields0() {
        return new Fields<Record>(new Field[0]);
    }
}

