/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.ParquetReadOptions;
import hive.org.apache.parquet.bytes.ByteBufferAllocator;
import hive.org.apache.parquet.bytes.ByteBufferReleaser;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.page.DataPage;
import hive.org.apache.parquet.column.page.DataPageV1;
import hive.org.apache.parquet.column.page.DataPageV2;
import hive.org.apache.parquet.column.page.DictionaryPage;
import hive.org.apache.parquet.column.page.DictionaryPageReadStore;
import hive.org.apache.parquet.column.page.PageReadStore;
import hive.org.apache.parquet.column.page.PageReader;
import hive.org.apache.parquet.compression.CompressionCodecFactory;
import hive.org.apache.parquet.crypto.AesCipher;
import hive.org.apache.parquet.crypto.ModuleCipherFactory;
import hive.org.apache.parquet.format.BlockCipher;
import hive.org.apache.parquet.hadoop.ParquetFileReaderMetrics;
import hive.org.apache.parquet.hadoop.ParquetMetricsCallback;
import hive.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import hive.org.apache.parquet.internal.filter2.columnindex.RowRanges;
import hive.org.apache.parquet.io.ParquetDecodingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnChunkPageReadStore
implements PageReadStore,
DictionaryPageReadStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnChunkPageReadStore.class);
    private final Map<ColumnDescriptor, ColumnChunkPageReader> readers = new HashMap<ColumnDescriptor, ColumnChunkPageReader>();
    private final long rowCount;
    private final long rowIndexOffset;
    private final RowRanges rowRanges;
    private ByteBufferAllocator allocator;
    private ByteBufferReleaser releaser;

    public ColumnChunkPageReadStore(long rowCount) {
        this(rowCount, -1L);
    }

    ColumnChunkPageReadStore(RowRanges rowRanges) {
        this(rowRanges, -1L);
    }

    ColumnChunkPageReadStore(long rowCount, long rowIndexOffset) {
        this.rowCount = rowCount;
        this.rowIndexOffset = rowIndexOffset;
        this.rowRanges = null;
    }

    ColumnChunkPageReadStore(RowRanges rowRanges, long rowIndexOffset) {
        this.rowRanges = rowRanges;
        this.rowIndexOffset = rowIndexOffset;
        this.rowCount = rowRanges.rowCount();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Optional<Long> getRowIndexOffset() {
        return this.rowIndexOffset < 0L ? Optional.empty() : Optional.of(this.rowIndexOffset);
    }

    @Override
    public PageReader getPageReader(ColumnDescriptor path) {
        PageReader pageReader = this.readers.get(path);
        if (pageReader == null) {
            throw new IllegalArgumentException(path + " is not in the store: " + this.readers.keySet() + " " + this.rowCount);
        }
        return pageReader;
    }

    @Override
    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        return this.readers.get(descriptor).readDictionaryPage();
    }

    @Override
    public Optional<PrimitiveIterator.OfLong> getRowIndexes() {
        return this.rowRanges == null ? Optional.empty() : Optional.of(this.rowRanges.iterator());
    }

    void addColumn(ColumnDescriptor path, ColumnChunkPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new RuntimeException(path + " was added twice");
        }
    }

    void setReleaser(ByteBufferReleaser releaser) {
        this.releaser = releaser;
    }

    @Override
    public void close() {
        for (ColumnChunkPageReader reader : this.readers.values()) {
            reader.releaseBuffers();
        }
        this.releaser.close();
    }

    static final class ColumnChunkPageReader
    implements PageReader {
        private final CompressionCodecFactory.BytesInputDecompressor decompressor;
        private final long valueCount;
        private final Queue<DataPage> compressedPages;
        private final DictionaryPage compressedDictionaryPage;
        private final OffsetIndex offsetIndex;
        private final long rowCount;
        private final ParquetReadOptions options;
        private int pageIndex = 0;
        private final BlockCipher.Decryptor blockDecryptor;
        private final byte[] dataPageAAD;
        private final byte[] dictionaryPageAAD;
        private final ByteBufferReleaser releaser;

        ColumnChunkPageReader(CompressionCodecFactory.BytesInputDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex, long rowCount, BlockCipher.Decryptor blockDecryptor, byte[] fileAAD, int rowGroupOrdinal, int columnOrdinal, ParquetReadOptions options) {
            this.decompressor = decompressor;
            this.compressedPages = new ArrayDeque<DataPage>(compressedPages);
            this.compressedDictionaryPage = compressedDictionaryPage;
            long count = 0L;
            for (DataPage p : compressedPages) {
                count += (long)p.getValueCount();
            }
            this.valueCount = count;
            this.offsetIndex = offsetIndex;
            this.rowCount = rowCount;
            this.options = options;
            this.releaser = new ByteBufferReleaser(options.getAllocator());
            this.blockDecryptor = blockDecryptor;
            if (null != blockDecryptor) {
                this.dataPageAAD = AesCipher.createModuleAAD(fileAAD, ModuleCipherFactory.ModuleType.DataPage, rowGroupOrdinal, columnOrdinal, 0);
                this.dictionaryPageAAD = AesCipher.createModuleAAD(fileAAD, ModuleCipherFactory.ModuleType.DictionaryPage, rowGroupOrdinal, columnOrdinal, -1);
            } else {
                this.dataPageAAD = null;
                this.dictionaryPageAAD = null;
            }
        }

        private int getPageOrdinal(int currentPageIndex) {
            if (null == this.offsetIndex) {
                return currentPageIndex;
            }
            return this.offsetIndex.getPageOrdinal(currentPageIndex);
        }

        @Override
        public long getTotalValueCount() {
            return this.valueCount;
        }

        @Override
        public DataPage readPage() {
            DataPage compressedPage = this.compressedPages.poll();
            if (compressedPage == null) {
                return null;
            }
            final int currentPageIndex = this.pageIndex++;
            if (null != this.blockDecryptor) {
                AesCipher.quickUpdatePageAAD(this.dataPageAAD, this.getPageOrdinal(currentPageIndex));
            }
            return compressedPage.accept(new DataPage.Visitor<DataPage>(){

                @Override
                public DataPage visit(DataPageV1 dataPageV1) {
                    try {
                        DataPageV1 decompressedPage;
                        BytesInput decompressed;
                        BytesInput bytes = dataPageV1.getBytes();
                        if (options.getAllocator().isDirect() && options.useOffHeapDecryptBuffer()) {
                            ByteBuffer byteBuffer = bytes.toByteBuffer(releaser);
                            if (!byteBuffer.isDirect()) {
                                throw new ParquetDecodingException("Expected a direct buffer");
                            }
                            if (blockDecryptor != null) {
                                byteBuffer = blockDecryptor.decrypt(byteBuffer, dataPageAAD);
                            }
                            long compressedSize = byteBuffer.limit();
                            ByteBuffer decompressedBuffer = options.getAllocator().allocate(dataPageV1.getUncompressedSize());
                            releaser.releaseLater(decompressedBuffer);
                            long start = System.nanoTime();
                            decompressor.decompress(byteBuffer, (int)compressedSize, decompressedBuffer, dataPageV1.getUncompressedSize());
                            this.setDecompressMetrics(bytes, start);
                            decompressedBuffer.flip();
                            decompressed = BytesInput.from(decompressedBuffer);
                        } else {
                            if (null != blockDecryptor) {
                                bytes = BytesInput.from(blockDecryptor.decrypt(bytes.toByteArray(), dataPageAAD));
                            }
                            long start = System.nanoTime();
                            decompressed = decompressor.decompress(bytes, dataPageV1.getUncompressedSize());
                            this.setDecompressMetrics(bytes, start);
                        }
                        if (offsetIndex == null) {
                            decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                        } else {
                            long firstRowIndex = offsetIndex.getFirstRowIndex(currentPageIndex);
                            decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, Math.toIntExact(offsetIndex.getLastRowIndex(currentPageIndex, rowCount) - firstRowIndex + 1L), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                        }
                        if (dataPageV1.getCrc().isPresent()) {
                            decompressedPage.setCrc(dataPageV1.getCrc().getAsInt());
                        }
                        return decompressedPage;
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                }

                @Override
                public DataPage visit(DataPageV2 dataPageV2) {
                    if (!dataPageV2.isCompressed() && offsetIndex == null && null == blockDecryptor) {
                        return dataPageV2;
                    }
                    BytesInput pageBytes = dataPageV2.getData();
                    try {
                        if (options.getAllocator().isDirect() && options.useOffHeapDecryptBuffer()) {
                            ByteBuffer byteBuffer = pageBytes.toByteBuffer(releaser);
                            if (!byteBuffer.isDirect()) {
                                throw new ParquetDecodingException("Expected a direct buffer");
                            }
                            if (blockDecryptor != null) {
                                byteBuffer = blockDecryptor.decrypt(byteBuffer, dataPageAAD);
                            }
                            long compressedSize = byteBuffer.limit();
                            if (dataPageV2.isCompressed()) {
                                int uncompressedSize = Math.toIntExact((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size());
                                ByteBuffer decompressedBuffer = options.getAllocator().allocate(uncompressedSize);
                                releaser.releaseLater(decompressedBuffer);
                                long start = System.nanoTime();
                                decompressor.decompress(byteBuffer, (int)compressedSize, decompressedBuffer, uncompressedSize);
                                this.setDecompressMetrics(pageBytes, start);
                                decompressedBuffer.flip();
                                pageBytes = BytesInput.from(decompressedBuffer);
                            } else {
                                pageBytes = BytesInput.from(byteBuffer);
                            }
                        } else {
                            if (null != blockDecryptor) {
                                pageBytes = BytesInput.from(blockDecryptor.decrypt(pageBytes.toByteArray(), dataPageAAD));
                            }
                            if (dataPageV2.isCompressed()) {
                                int uncompressedSize = Math.toIntExact((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size());
                                long start = System.nanoTime();
                                pageBytes = decompressor.decompress(pageBytes, uncompressedSize);
                                this.setDecompressMetrics(pageBytes, start);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", e);
                    }
                    DataPageV2 decompressedPage = offsetIndex == null ? DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), pageBytes, dataPageV2.getStatistics()) : DataPageV2.uncompressed(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), offsetIndex.getFirstRowIndex(currentPageIndex), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), pageBytes, dataPageV2.getStatistics());
                    if (dataPageV2.getCrc().isPresent()) {
                        decompressedPage.setCrc(dataPageV2.getCrc().getAsInt());
                    }
                    return decompressedPage;
                }
            });
        }

        private void setDecompressMetrics(BytesInput bytes, long start) {
            ParquetMetricsCallback metricsCallback = this.options.getMetricsCallback();
            if (metricsCallback != null) {
                long time = Math.max(System.nanoTime() - start, 0L);
                long len = bytes.size();
                double throughput = (double)len / (double)time * 1.0E9 / 1048576.0;
                LOG.debug("Decompress block: Length: {} MB, Time: {} msecs, throughput: {} MB/s", new Object[]{len / 0x100000L, time / 1000000L, throughput});
                metricsCallback.setDuration(ParquetFileReaderMetrics.DecompressTime.name(), time);
                metricsCallback.setValueLong(ParquetFileReaderMetrics.DecompressSize.name(), len);
                metricsCallback.setValueDouble(ParquetFileReaderMetrics.DecompressThroughput.name(), throughput);
            }
        }

        @Override
        public DictionaryPage readDictionaryPage() {
            if (this.compressedDictionaryPage == null) {
                return null;
            }
            try {
                BytesInput bytes = this.compressedDictionaryPage.getBytes();
                if (null != this.blockDecryptor) {
                    bytes = BytesInput.from(this.blockDecryptor.decrypt(bytes.toByteArray(), this.dictionaryPageAAD));
                }
                long start = System.nanoTime();
                this.setDecompressMetrics(bytes, start);
                DictionaryPage decompressedPage = new DictionaryPage(this.decompressor.decompress(bytes, this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
                if (this.compressedDictionaryPage.getCrc().isPresent()) {
                    decompressedPage.setCrc(this.compressedDictionaryPage.getCrc().getAsInt());
                }
                return decompressedPage;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Could not decompress dictionary page", e);
            }
        }

        private void releaseBuffers() {
            this.releaser.close();
        }
    }
}

