/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.mapred.AvroCollector;
import hive.org.apache.avro.mapred.AvroMapper;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.mapred.MapCollector;
import hive.org.apache.avro.mapred.TaggedInputSplit;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

class DelegatingMapper<IN, OUT, K, V, KO, VO>
extends MapReduceBase
implements Mapper<AvroWrapper<IN>, NullWritable, KO, VO> {
    AvroMapper<IN, OUT> mapper;
    JobConf conf;
    boolean isMapOnly;
    AvroCollector<OUT> out;

    DelegatingMapper() {
    }

    public void configure(JobConf conf) {
        this.conf = conf;
        this.isMapOnly = conf.getNumReduceTasks() == 0;
    }

    public void map(AvroWrapper<IN> wrapper, NullWritable value, OutputCollector<KO, VO> collector, Reporter reporter) throws IOException {
        if (this.mapper == null) {
            TaggedInputSplit is = (TaggedInputSplit)reporter.getInputSplit();
            Class<? extends AvroMapper> mapperClass = is.getMapperClass();
            this.mapper = (AvroMapper)ReflectionUtils.newInstance(mapperClass, (Configuration)this.conf);
        }
        if (this.out == null) {
            this.out = new MapCollector(collector, this.isMapOnly);
        }
        this.mapper.map(wrapper.datum(), this.out, reporter);
    }
}

