/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.drill.metastore.iceberg.exceptions.IcebergMetastoreException;
import org.apache.drill.metastore.iceberg.write.File;
import org.apache.drill.metastore.iceberg.write.FileWriter;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;

public class ParquetFileWriter
implements FileWriter {
    private final Table table;
    private final List<Record> records = new ArrayList<Record>();
    private String location;
    private String name;

    public ParquetFileWriter(Table table) {
        this.table = table;
    }

    @Override
    public FileWriter records(List<Record> records) {
        this.records.addAll(records);
        return this;
    }

    @Override
    public FileWriter location(String location) {
        this.location = location;
        return this;
    }

    @Override
    public FileWriter name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public File write() {
        Objects.requireNonNull(this.location, "File create location must be specified");
        Objects.requireNonNull(this.name, "File name must be specified");
        OutputFile outputFile = this.table.io().newOutputFile(new Path(this.location, FileFormat.PARQUET.addExtension(this.name)).toUri().getPath());
        FileAppender fileAppender = null;
        try {
            fileAppender = Parquet.write((OutputFile)outputFile).forTable(this.table).createWriterFunc(GenericParquetWriter::buildWriter).build();
            fileAppender.addAll(this.records);
            fileAppender.close();
            return new File(outputFile, fileAppender.metrics());
        }
        catch (IOException | ClassCastException | RuntimeIOException e) {
            if (fileAppender != null) {
                try {
                    fileAppender.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IcebergMetastoreException(String.format("Unable to write data into parquet file [%s]", outputFile.location()), e);
        }
    }
}

