/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;

public class KafkaPartitionScanSpec {
    private final String topicName;
    private final int partitionId;
    private long startOffset;
    private long endOffset;

    @JsonCreator
    public KafkaPartitionScanSpec(@JsonProperty(value="topicName") String topicName, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="startOffset") long startOffset, @JsonProperty(value="endOffset") long endOffset) {
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public void mergeScanSpec(String functionName, KafkaPartitionScanSpec scanSpec) {
        switch (functionName) {
            case "booleanAnd": {
                if (this.startOffset < scanSpec.startOffset) {
                    this.startOffset = scanSpec.startOffset;
                }
                if (this.endOffset <= scanSpec.endOffset) break;
                this.endOffset = scanSpec.endOffset;
                break;
            }
            case "booleanOr": {
                if (scanSpec.startOffset < this.startOffset) {
                    this.startOffset = scanSpec.startOffset;
                }
                if (scanSpec.endOffset <= this.endOffset) break;
                this.endOffset = scanSpec.endOffset;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof KafkaPartitionScanSpec) {
            KafkaPartitionScanSpec that = (KafkaPartitionScanSpec)obj;
            return this.topicName.equals(that.topicName) && this.partitionId == that.partitionId && this.startOffset == that.startOffset && this.endOffset == that.endOffset;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.partitionId, this.startOffset, this.endOffset);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("topicName", this.topicName).field("partitionId", this.partitionId).field("startOffset", (Object)this.startOffset).field("endOffset", (Object)this.endOffset).toString();
    }

    public KafkaPartitionScanSpec clone() {
        return new KafkaPartitionScanSpec(this.topicName, this.partitionId, this.startOffset, this.endOffset);
    }
}

