/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Token
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Token.class);
    private final List<TokenOutputField> outputFields = new ArrayList<TokenOutputField>();
    private final String regex;
    private final int startPos;
    private final int length;
    private final int prio;
    protected String warningMessageWhenUsed = null;
    private Dissector customDissector = null;

    public Token(String nRegex, int nStartPos, int nLength, int nPrio) {
        this.regex = nRegex;
        this.startPos = nStartPos;
        this.length = nLength;
        this.prio = nPrio;
    }

    public Token addOutputField(String type, String name, EnumSet<Casts> casts) {
        this.outputFields.add(new TokenOutputField(type, name, casts));
        return this;
    }

    public Token addOutputFields(List<TokenOutputField> nOutputFields) {
        this.outputFields.addAll(nOutputFields);
        return this;
    }

    public List<TokenOutputField> getOutputFields() {
        return this.outputFields;
    }

    public boolean canProduceADesiredFieldName(Set<String> desiredNames) {
        for (TokenOutputField tokenOutputField : this.outputFields) {
            if (!desiredNames.contains(tokenOutputField.getName())) continue;
            return true;
        }
        return false;
    }

    public void setCustomDissector(Dissector dissector) {
        this.customDissector = dissector;
    }

    public Dissector getCustomDissector() {
        return this.customDissector;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrio() {
        return this.prio;
    }

    public void setWarningMessageWhenUsed(String message) {
        this.warningMessageWhenUsed = message;
    }

    public void tokenWasUsed() {
        if (this.warningMessageWhenUsed != null) {
            LOG.warn("------------------------------------------------------------------------");
            LOG.warn(this.warningMessageWhenUsed, this.outputFields);
            LOG.warn("------------------------------------------------------------------------");
        }
    }

    public String toString() {
        return "{" + this.outputFields + " (" + this.startPos + "+" + this.length + ");Prio=" + this.prio + "}";
    }
}

