/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import java.io.Serializable;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FileNames$ {
    public static final FileNames$ MODULE$ = new FileNames$();
    private static final Pattern deltaFilePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d+\\.json")).pattern();
    private static final Pattern checkpointFilePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).pattern();

    public Pattern deltaFilePattern() {
        return deltaFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return checkpointFilePattern;
    }

    public Path deltaFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.json", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public long deltaVersion(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(path.getName()), ".json")));
    }

    public Path checkpointPrefix(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.checkpoint", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.checkpoint.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return package$.MODULE$.Range().apply(1, numParts + 1).map((Function1 & Serializable)i -> FileNames$.$anonfun$checkpointFileWithParts$1(path, version, numParts, BoxesRunTime.unboxToInt((Object)i)));
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        return ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])segments)) != 5 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[3]))));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isDeltaFile(Path path) {
        return this.deltaFilePattern().matcher(path.getName()).matches();
    }

    public long checkpointVersion(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0]));
    }

    public long getFileVersion(Path path) {
        long l;
        if (this.isCheckpointFile(path)) {
            l = this.checkpointVersion(path);
        } else if (this.isDeltaFile(path)) {
            l = this.deltaVersion(path);
        } else {
            throw new AssertionError((Object)new StringBuilder(47).append("Unexpected file type found in transaction log: ").append(path).toString());
        }
        return l;
    }

    public Path absolutePath(Path parentDir, String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(parentDir, p);
    }

    public static final /* synthetic */ Path $anonfun$checkpointFileWithParts$1(Path path$1, long version$1, int numParts$1, int i) {
        long arg$macro$1 = version$1;
        int arg$macro$2 = i;
        int arg$macro$3 = numParts$1;
        return new Path(path$1, StringOps$.MODULE$.format$extension("%020d.checkpoint.%010d.%010d.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)})));
    }

    private FileNames$() {
    }
}

