/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.ThreadPools;

public class ParallelIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final Iterable<? extends Iterable<T>> iterables;
    private final ExecutorService workerPool;

    public ParallelIterable(Iterable<? extends Iterable<T>> iterables, ExecutorService workerPool) {
        this.iterables = iterables;
        this.workerPool = workerPool;
    }

    public CloseableIterator<T> iterator() {
        ParallelIterator iter = new ParallelIterator(this.iterables, this.workerPool);
        this.addCloseable((Closeable)((Object)iter));
        return iter;
    }

    private static class ParallelIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<Runnable> tasks;
        private final ExecutorService workerPool;
        private final Future<?>[] taskFutures;
        private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
        private boolean closed = false;

        private ParallelIterator(Iterable<? extends Iterable<T>> iterables, ExecutorService workerPool) {
            this.tasks = Iterables.transform(iterables, iterable -> () -> {
                try (Closeable ignored = iterable instanceof Closeable ? (Closeable)((Object)iterable) : () -> {};){
                    for (Object item : iterable) {
                        this.queue.add(item);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close iterable", new Object[0]);
                }
            }).iterator();
            this.workerPool = workerPool;
            this.taskFutures = new Future[2 * ThreadPools.WORKER_THREAD_POOL_SIZE];
        }

        public void close() {
            for (int i = 0; i < this.taskFutures.length; ++i) {
                if (this.taskFutures[i] == null || this.taskFutures[i].isDone()) continue;
                this.taskFutures[i].cancel(true);
            }
            this.closed = true;
        }

        private boolean checkTasks() {
            boolean hasRunningTask = false;
            for (int i = 0; i < this.taskFutures.length; ++i) {
                if (this.taskFutures[i] == null || this.taskFutures[i].isDone()) {
                    if (this.taskFutures[i] != null) {
                        try {
                            this.taskFutures[i].get();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof RuntimeException) {
                                throw (RuntimeException)e.getCause();
                            }
                            throw new RuntimeException("Failed while running parallel task", e.getCause());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("Interrupted while running parallel task", e);
                        }
                    }
                    this.taskFutures[i] = this.submitNextTask();
                }
                if (this.taskFutures[i] == null) continue;
                hasRunningTask = true;
            }
            return this.tasks.hasNext() || hasRunningTask;
        }

        private Future<?> submitNextTask() {
            if (this.tasks.hasNext()) {
                return this.workerPool.submit(this.tasks.next());
            }
            return null;
        }

        public synchronized boolean hasNext() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
            if (!this.queue.isEmpty()) {
                return true;
            }
            while (this.checkTasks()) {
                if (!this.queue.isEmpty()) {
                    return true;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            return !this.queue.isEmpty();
        }

        public synchronized T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.queue.poll();
        }
    }
}

