/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.TempFileCommentsTable;
import com.github.pjfanning.poi.xssf.streaming.TempFileSharedStringsTable;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFRelation;

public class SXSSFFactory
extends XSSFFactory {
    private boolean encryptTempFiles = false;
    private boolean enableTempFileSharedStrings = true;
    private boolean enableTempFileComments = false;

    public SXSSFFactory() {
    }

    @Deprecated
    public SXSSFFactory(boolean encryptTempFiles) {
        this.encryptTempFiles = encryptTempFiles;
    }

    public SXSSFFactory encryptTempFiles(boolean encryptTempFiles) {
        this.encryptTempFiles = encryptTempFiles;
        return this;
    }

    public SXSSFFactory enableTempFileSharedStrings(boolean enableTempFileSharedStrings) {
        this.enableTempFileSharedStrings = enableTempFileSharedStrings;
        return this;
    }

    public SXSSFFactory enableTempFileComments(boolean enableTempFileComments) {
        this.enableTempFileComments = enableTempFileComments;
        return this;
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        if (XSSFRelation.SHARED_STRINGS.getRelation().equals(descriptor.getRelation()) && this.enableTempFileSharedStrings) {
            try {
                return new TempFileSharedStringsTable(this.encryptTempFiles);
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception creating TempFileSharedStringsTable; com.h2database h2 jar is required for this feature and is not included as a core dependency of poi-shared-strings");
            }
        }
        if (XSSFRelation.SHEET_COMMENTS.getRelation().equals(descriptor.getRelation()) && this.enableTempFileComments) {
            try {
                return new TempFileCommentsTable(this.encryptTempFiles);
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception creating TempFileCommentsTable; com.h2database h2 jar is required for this feature and is not included as a core dependency of poi-shared-strings");
            }
        }
        return super.newDocumentPart(descriptor);
    }
}

