/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.hdfs.store.BmcOutputStream;
import com.oracle.bmc.hdfs.util.BiFunction;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import com.oracle.bmc.util.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BmcInMemoryOutputStream
extends BmcOutputStream {
    private final int bufferSizeInBytes;
    private ByteArrayOutputStream baos;

    public BmcInMemoryOutputStream(UploadManager uploadManager, int bufferSizeInBytes, BiFunction<Long, InputStream, UploadManager.UploadRequest> requestBuilderFn) {
        super(uploadManager, requestBuilderFn);
        this.bufferSizeInBytes = bufferSizeInBytes;
    }

    @Override
    protected OutputStream createOutputBufferStream() {
        this.baos = new ByteArrayOutputStream(this.bufferSizeInBytes);
        return this.baos;
    }

    @Override
    protected long getInputStreamLengthInBytes() throws IOException {
        return this.baos.size();
    }

    @Override
    protected InputStream getInputStreamFromBufferedStream() {
        return StreamUtils.createByteArrayInputStream((byte[])this.baos.toByteArray());
    }
}

