/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.ExpandableByteBuf;
import io.netty.buffer.PooledByteBufAllocatorL;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;

public class DrillByteBufAllocator
extends AbstractByteBufAllocator {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_MAX_COMPOSITE_COMPONENTS = 16;
    private static final PooledByteBufAllocatorL HEAP_ALLOCATOR = AllocationManager.INNER_ALLOCATOR;
    private final BufferAllocator allocator;

    public DrillByteBufAllocator(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBuf buffer() {
        return this.buffer(4096);
    }

    public ByteBuf buffer(int initialCapacity) {
        return new ExpandableByteBuf((ByteBuf)this.allocator.buffer(initialCapacity), this.allocator);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity);
    }

    public ByteBuf ioBuffer() {
        return this.buffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.buffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity);
    }

    public ByteBuf directBuffer() {
        return this.buffer();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.allocator.buffer(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return this.compositeBuffer(16);
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return new CompositeByteBuf((ByteBufAllocator)this, true, maxNumComponents);
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.compositeBuffer(maxNumComponents);
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return HEAP_ALLOCATOR.allocateHeap(initialCapacity, maxCapacity);
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity, maxCapacity);
    }

    public boolean isDirectBufferPooled() {
        return false;
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return new CompositeByteBuf((ByteBufAllocator)this, false, maxNumComponents);
    }
}

