/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultPreparedStatement
implements PreparedStatement {
    private final ByteBuffer id;
    private final RepreparePayload repreparePayload;
    private final ColumnDefinitions variableDefinitions;
    private final List<Integer> partitionKeyIndices;
    private volatile ResultMetadata resultMetadata;
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;
    private final String executionProfileNameForBoundStatements;
    private final DriverExecutionProfile executionProfileForBoundStatements;
    private final ByteBuffer pagingStateForBoundStatements;
    private final CqlIdentifier routingKeyspaceForBoundStatements;
    private final ByteBuffer routingKeyForBoundStatements;
    private final Token routingTokenForBoundStatements;
    private final Map<String, ByteBuffer> customPayloadForBoundStatements;
    private final Boolean areBoundStatementsIdempotent;
    private final boolean areBoundStatementsTracing;
    private final int pageSizeForBoundStatements;
    private final ConsistencyLevel consistencyLevelForBoundStatements;
    private final ConsistencyLevel serialConsistencyLevelForBoundStatements;
    private final Duration timeoutForBoundStatements;
    private final Partitioner partitioner;

    public DefaultPreparedStatement(ByteBuffer id, String query, ColumnDefinitions variableDefinitions, List<Integer> partitionKeyIndices, ByteBuffer resultMetadataId, ColumnDefinitions resultSetDefinitions, CqlIdentifier keyspace, Partitioner partitioner, Map<String, ByteBuffer> customPayloadForPrepare, String executionProfileNameForBoundStatements, DriverExecutionProfile executionProfileForBoundStatements, CqlIdentifier routingKeyspaceForBoundStatements, ByteBuffer routingKeyForBoundStatements, Token routingTokenForBoundStatements, Map<String, ByteBuffer> customPayloadForBoundStatements, Boolean areBoundStatementsIdempotent, Duration timeoutForBoundStatements, ByteBuffer pagingStateForBoundStatements, int pageSizeForBoundStatements, ConsistencyLevel consistencyLevelForBoundStatements, ConsistencyLevel serialConsistencyLevelForBoundStatements, boolean areBoundStatementsTracing, CodecRegistry codecRegistry, ProtocolVersion protocolVersion) {
        this.id = id;
        this.partitionKeyIndices = partitionKeyIndices;
        this.repreparePayload = new RepreparePayload(id, query, keyspace, customPayloadForPrepare);
        this.variableDefinitions = variableDefinitions;
        this.resultMetadata = new ResultMetadata(resultMetadataId, resultSetDefinitions);
        this.executionProfileNameForBoundStatements = executionProfileNameForBoundStatements;
        this.executionProfileForBoundStatements = executionProfileForBoundStatements;
        this.routingKeyspaceForBoundStatements = routingKeyspaceForBoundStatements;
        this.routingKeyForBoundStatements = routingKeyForBoundStatements;
        this.routingTokenForBoundStatements = routingTokenForBoundStatements;
        this.customPayloadForBoundStatements = customPayloadForBoundStatements;
        this.areBoundStatementsIdempotent = areBoundStatementsIdempotent;
        this.timeoutForBoundStatements = timeoutForBoundStatements;
        this.pagingStateForBoundStatements = pagingStateForBoundStatements;
        this.pageSizeForBoundStatements = pageSizeForBoundStatements;
        this.consistencyLevelForBoundStatements = consistencyLevelForBoundStatements;
        this.serialConsistencyLevelForBoundStatements = serialConsistencyLevelForBoundStatements;
        this.areBoundStatementsTracing = areBoundStatementsTracing;
        this.partitioner = partitioner;
        this.codecRegistry = codecRegistry;
        this.protocolVersion = protocolVersion;
    }

    @Override
    @NonNull
    public ByteBuffer getId() {
        return this.id;
    }

    @Override
    @NonNull
    public String getQuery() {
        return this.repreparePayload.query;
    }

    @Override
    @NonNull
    public ColumnDefinitions getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    @Override
    @NonNull
    public List<Integer> getPartitionKeyIndices() {
        return this.partitionKeyIndices;
    }

    @Override
    public ByteBuffer getResultMetadataId() {
        return this.resultMetadata.resultMetadataId;
    }

    @Override
    @NonNull
    public ColumnDefinitions getResultSetDefinitions() {
        return this.resultMetadata.resultSetDefinitions;
    }

    @Override
    public void setResultMetadata(@NonNull ByteBuffer newResultMetadataId, @NonNull ColumnDefinitions newResultSetDefinitions) {
        this.resultMetadata = new ResultMetadata(newResultMetadataId, newResultSetDefinitions);
    }

    @Override
    @NonNull
    public BoundStatement bind(Object ... values) {
        return new DefaultBoundStatement(this, this.variableDefinitions, ValuesHelper.encodePreparedValues(values, this.variableDefinitions, this.codecRegistry, this.protocolVersion), this.executionProfileNameForBoundStatements, this.executionProfileForBoundStatements, this.routingKeyspaceForBoundStatements, this.routingKeyForBoundStatements, this.routingTokenForBoundStatements, this.customPayloadForBoundStatements, this.areBoundStatementsIdempotent, this.areBoundStatementsTracing, Long.MIN_VALUE, this.pagingStateForBoundStatements, this.pageSizeForBoundStatements, this.consistencyLevelForBoundStatements, this.serialConsistencyLevelForBoundStatements, this.timeoutForBoundStatements, this.codecRegistry, this.protocolVersion, null, Integer.MIN_VALUE);
    }

    @Override
    @NonNull
    public BoundStatementBuilder boundStatementBuilder(Object ... values) {
        return new BoundStatementBuilder(this, this.variableDefinitions, ValuesHelper.encodePreparedValues(values, this.variableDefinitions, this.codecRegistry, this.protocolVersion), this.executionProfileNameForBoundStatements, this.executionProfileForBoundStatements, this.routingKeyspaceForBoundStatements, this.routingKeyForBoundStatements, this.routingTokenForBoundStatements, this.customPayloadForBoundStatements, this.areBoundStatementsIdempotent, this.areBoundStatementsTracing, Long.MIN_VALUE, this.pagingStateForBoundStatements, this.pageSizeForBoundStatements, this.consistencyLevelForBoundStatements, this.serialConsistencyLevelForBoundStatements, this.timeoutForBoundStatements, this.codecRegistry, this.protocolVersion);
    }

    public RepreparePayload getRepreparePayload() {
        return this.repreparePayload;
    }

    private static class ResultMetadata {
        private ByteBuffer resultMetadataId;
        private ColumnDefinitions resultSetDefinitions;

        private ResultMetadata(ByteBuffer resultMetadataId, ColumnDefinitions resultSetDefinitions) {
            this.resultMetadataId = resultMetadataId;
            this.resultSetDefinitions = resultSetDefinitions;
        }
    }
}

