/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.internal.core.util.concurrent.PromiseCombiner;
import com.datastax.oss.driver.shaded.netty.channel.ChannelDuplexHandler;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.channel.ChannelPromise;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class ConnectInitHandler
extends ChannelDuplexHandler {
    private ChannelPromise initPromise;
    private ChannelHandlerContext ctx;

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise callerPromise) throws Exception {
        this.ctx = ctx;
        this.initPromise = ctx.channel().newPromise();
        ChannelPromise realConnectPromise = ctx.channel().newPromise();
        super.connect(ctx, remoteAddress, localAddress, realConnectPromise);
        realConnectPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.onRealConnect(ctx)));
        PromiseCombiner.combine(callerPromise, realConnectPromise, this.initPromise);
    }

    protected abstract void onRealConnect(ChannelHandlerContext var1);

    protected boolean setConnectSuccess() {
        boolean result = this.initPromise.trySuccess();
        if (result) {
            this.ctx.pipeline().remove(this);
        }
        return result;
    }

    protected void setConnectFailure(Throwable cause) {
        if (this.initPromise.tryFailure(cause)) {
            this.ctx.channel().close();
        }
    }
}

