/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.openid.ErrUnion;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserInfoError {
    protected final ErrUnion err;
    protected final String errorMessage;

    public UserInfoError(ErrUnion err, String errorMessage) {
        this.err = err;
        if (errorMessage == null) {
            throw new IllegalArgumentException("Required value for 'errorMessage' is null");
        }
        this.errorMessage = errorMessage;
    }

    public UserInfoError() {
        this(null, "");
    }

    public ErrUnion getErr() {
        return this.err;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.err, this.errorMessage});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserInfoError other = (UserInfoError)obj;
            return (this.err == other.err || this.err != null && this.err.equals(other.err)) && (this.errorMessage == other.errorMessage || this.errorMessage.equals(other.errorMessage));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserInfoError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserInfoError value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.err != null) {
                g.writeFieldName("err");
                StoneSerializers.nullable(ErrUnion.Serializer.INSTANCE).serialize(value.err, g);
            }
            g.writeFieldName("error_message");
            StoneSerializers.string().serialize(value.errorMessage, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserInfoError deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_errorMessage;
            ErrUnion f_err;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_err = null;
                f_errorMessage = "";
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("err".equals(field)) {
                        f_err = StoneSerializers.nullable(ErrUnion.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("error_message".equals(field)) {
                        f_errorMessage = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserInfoError value = new UserInfoError(f_err, f_errorMessage);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected ErrUnion err = null;
        protected String errorMessage = "";

        protected Builder() {
        }

        public Builder withErr(ErrUnion err) {
            this.err = err;
            return this;
        }

        public Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage : "";
            return this;
        }

        public UserInfoError build() {
            return new UserInfoError(this.err, this.errorMessage);
        }
    }
}

