/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class ExportMetadata {
    protected final String name;
    protected final long size;
    protected final String exportHash;
    protected final Long paperRevision;

    public ExportMetadata(String name, long size, String exportHash, Long paperRevision) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        this.size = size;
        if (exportHash != null) {
            if (exportHash.length() < 64) {
                throw new IllegalArgumentException("String 'exportHash' is shorter than 64");
            }
            if (exportHash.length() > 64) {
                throw new IllegalArgumentException("String 'exportHash' is longer than 64");
            }
        }
        this.exportHash = exportHash;
        this.paperRevision = paperRevision;
    }

    public ExportMetadata(String name, long size) {
        this(name, size, null, null);
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public String getExportHash() {
        return this.exportHash;
    }

    public Long getPaperRevision() {
        return this.paperRevision;
    }

    public static Builder newBuilder(String name, long size) {
        return new Builder(name, size);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.size, this.exportHash, this.paperRevision});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ExportMetadata other = (ExportMetadata)obj;
            return (this.name == other.name || this.name.equals(other.name)) && this.size == other.size && (this.exportHash == other.exportHash || this.exportHash != null && this.exportHash.equals(other.exportHash)) && (this.paperRevision == other.paperRevision || this.paperRevision != null && this.paperRevision.equals(other.paperRevision));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ExportMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ExportMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("size");
            StoneSerializers.uInt64().serialize((Long)value.size, g);
            if (value.exportHash != null) {
                g.writeFieldName("export_hash");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.exportHash, g);
            }
            if (value.paperRevision != null) {
                g.writeFieldName("paper_revision");
                StoneSerializers.nullable(StoneSerializers.int64()).serialize(value.paperRevision, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ExportMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_paperRevision;
            String f_exportHash;
            Long f_size;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_size = null;
                f_exportHash = null;
                f_paperRevision = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("export_hash".equals(field)) {
                        f_exportHash = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("paper_revision".equals(field)) {
                        f_paperRevision = StoneSerializers.nullable(StoneSerializers.int64()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_size == null) {
                    throw new JsonParseException(p, "Required field \"size\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ExportMetadata value = new ExportMetadata(f_name, f_size, f_exportHash, f_paperRevision);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String name;
        protected final long size;
        protected String exportHash;
        protected Long paperRevision;

        protected Builder(String name, long size) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            this.size = size;
            this.exportHash = null;
            this.paperRevision = null;
        }

        public Builder withExportHash(String exportHash) {
            if (exportHash != null) {
                if (exportHash.length() < 64) {
                    throw new IllegalArgumentException("String 'exportHash' is shorter than 64");
                }
                if (exportHash.length() > 64) {
                    throw new IllegalArgumentException("String 'exportHash' is longer than 64");
                }
            }
            this.exportHash = exportHash;
            return this;
        }

        public Builder withPaperRevision(Long paperRevision) {
            this.paperRevision = paperRevision;
            return this;
        }

        public ExportMetadata build() {
            return new ExportMetadata(this.name, this.size, this.exportHash, this.paperRevision);
        }
    }
}

