/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.transform;

import java.util.Collection;
import java.util.Map;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.DoubleExpressionPredicate;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.expressions.IsPredicate;
import org.apache.drill.metastore.expressions.ListPredicate;
import org.apache.drill.metastore.expressions.SimplePredicate;
import org.apache.drill.metastore.expressions.SingleExpressionPredicate;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class RdbmsFilterExpressionVisitor
implements FilterExpression.Visitor<Condition> {
    private final Map<MetastoreColumn, Field<?>> fields;

    public RdbmsFilterExpressionVisitor(Map<MetastoreColumn, Field<?>> fields) {
        this.fields = fields;
    }

    public Condition visit(SimplePredicate.Equal<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.eq(expression.value());
    }

    public Condition visit(SimplePredicate.NotEqual<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.trueCondition() : field.notEqual(expression.value());
    }

    public Condition visit(SimplePredicate.LessThan<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.lessThan(expression.value());
    }

    public Condition visit(SimplePredicate.LessThanOrEqual<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.lessOrEqual(expression.value());
    }

    public Condition visit(SimplePredicate.GreaterThan<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.greaterThan(expression.value());
    }

    public Condition visit(SimplePredicate.GreaterThanOrEqual<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.greaterOrEqual(expression.value());
    }

    public Condition visit(ListPredicate.In<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.in((Collection)expression.values());
    }

    public Condition visit(ListPredicate.NotIn<?> expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.trueCondition() : field.notIn((Collection)expression.values());
    }

    public Condition visit(IsPredicate.IsNull expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.trueCondition() : field.isNull();
    }

    public Condition visit(IsPredicate.IsNotNull expression) {
        Field<?> field = this.fields.get(expression.column());
        return field == null ? DSL.falseCondition() : field.isNotNull();
    }

    public Condition visit(SingleExpressionPredicate.Not expression) {
        return DSL.not((Condition)((Condition)expression.expression().accept((FilterExpression.Visitor)this)));
    }

    public Condition visit(DoubleExpressionPredicate.And expression) {
        Condition left = (Condition)expression.left().accept((FilterExpression.Visitor)this);
        Condition right = (Condition)expression.right().accept((FilterExpression.Visitor)this);
        return DSL.and((Condition)left, (Condition)right);
    }

    public Condition visit(DoubleExpressionPredicate.Or expression) {
        Condition left = (Condition)expression.left().accept((FilterExpression.Visitor)this);
        Condition right = (Condition)expression.right().accept((FilterExpression.Visitor)this);
        return DSL.or((Condition)left, (Condition)right);
    }
}

